/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionTest;
import hudson.plugins.git.extensions.impl.UserExclusion;
import org.junit.Assert;
import org.junit.Test;

public class UserExclusionTest
extends GitSCMExtensionTest {
    FreeStyleProject project;
    TestGitRepo repo;

    @Override
    public void before() throws Exception {
        this.repo = new TestGitRepo("repo", this.tmp.newFolder(), this.listener);
        this.project = this.setupBasicProject(this.repo);
    }

    @Override
    protected GitSCMExtension getExtension() {
        return new UserExclusion("Jane Doe");
    }

    @Test
    public void test() throws Exception {
        this.repo.commit("repo-init", this.repo.johnDoe, "repo0 initial commit");
        Assert.assertTrue((String)"scm polling should detect a change after initial commit", (boolean)this.project.poll(this.listener).hasChanges());
        this.build(this.project, Result.SUCCESS);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)this.project.poll(this.listener).hasChanges());
        this.repo.commit("repo-init", this.repo.janeDoe, "excluded user commit");
        Assert.assertFalse((String)"scm polling should ignore excluded user", (boolean)this.project.poll(this.listener).hasChanges());
        this.build(this.project, Result.SUCCESS);
        Assert.assertFalse((String)"scm polling should not detect any more changes after build", (boolean)this.project.poll(this.listener).hasChanges());
    }
}

