/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.model.Api;
import hudson.model.Result;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import java.util.ArrayList;
import org.eclipse.jgit.lib.ObjectId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BuildDataTest {
    private BuildData data;
    private final ObjectId sha1 = ObjectId.fromString((String)"929e92e3adaff2e6e1d752a8168c1598890fe84c");
    private final String remoteUrl = "git://github.com/jenkinsci/git-plugin.git";

    @Before
    public void setUp() throws Exception {
        this.data = new BuildData();
        this.data.addRemoteUrl("git://github.com/jenkinsci/git-plugin.git");
    }

    @Test
    public void testGetDisplayName() throws Exception {
        Assert.assertEquals((Object)this.data.getDisplayName(), (Object)"Git Build Data");
        String scmName = "";
        BuildData dataWithSCM = new BuildData(scmName);
        Assert.assertEquals((Object)this.data.getDisplayName(), (Object)"Git Build Data");
    }

    @Test
    public void testGetDisplayNameWithSCM() throws Exception {
        String scmName = "testSCM";
        BuildData dataWithSCM = new BuildData("testSCM");
        Assert.assertEquals((Object)"Git Build Data:testSCM", (Object)dataWithSCM.getDisplayName());
    }

    @Test
    public void testGetIconFileName() {
        Assert.assertTrue((boolean)this.data.getIconFileName().endsWith("/plugin/git/icons/git-32x32.png"));
    }

    @Test
    public void testGetUrlName() {
        Assert.assertEquals((Object)"git", (Object)this.data.getUrlName());
    }

    @Test
    public void testHasBeenBuilt() {
        Assert.assertFalse((boolean)this.data.hasBeenBuilt(this.sha1));
    }

    @Test
    public void testGetLastBuild() {
        Assert.assertEquals(null, (Object)this.data.getLastBuild(this.sha1));
    }

    @Test
    public void testSaveBuild() {
        Revision revision = new Revision(this.sha1);
        Build build = new Build(revision, 1, Result.SUCCESS);
        this.data.saveBuild(build);
        Assert.assertEquals((Object)build, (Object)this.data.getLastBuild(this.sha1));
    }

    @Test
    public void testGetLastBuildOfBranch() {
        String branchName = "origin/master";
        Assert.assertEquals(null, (Object)this.data.getLastBuildOfBranch(branchName));
        ArrayList<Branch> branches = new ArrayList<Branch>();
        Branch branch = new Branch(branchName, this.sha1);
        branches.add(branch);
        Revision revision = new Revision(this.sha1, branches);
        Build build = new Build(revision, 13, Result.FAILURE);
        this.data.saveBuild(build);
        Assert.assertEquals((Object)build, (Object)this.data.getLastBuildOfBranch(branchName));
    }

    @Test
    public void testGetLastBuiltRevision() {
        Revision revision = new Revision(this.sha1);
        Build build = new Build(revision, 1, Result.SUCCESS);
        this.data.saveBuild(build);
        Assert.assertEquals((Object)revision, (Object)this.data.getLastBuiltRevision());
    }

    @Test
    public void testGetBuildsByBranchName() {
        Assert.assertTrue((boolean)this.data.getBuildsByBranchName().isEmpty());
    }

    @Test
    public void testSetScmName() {
        Assert.assertEquals((Object)"", (Object)this.data.getScmName());
        String scmName = "Some SCM name";
        this.data.setScmName("Some SCM name");
        Assert.assertEquals((Object)"Some SCM name", (Object)this.data.getScmName());
    }

    @Test
    public void testAddRemoteUrl() {
        BuildData empty = new BuildData();
        Assert.assertTrue((boolean)empty.getRemoteUrls().isEmpty());
        Assert.assertEquals((long)1L, (long)this.data.getRemoteUrls().size());
        String remoteUrl2 = "https://github.com/jenkinsci/git-plugin.git/";
        this.data.addRemoteUrl(remoteUrl2);
        Assert.assertFalse((boolean)this.data.getRemoteUrls().isEmpty());
        Assert.assertTrue((String)"Second URL not found in remote URLs", (boolean)this.data.getRemoteUrls().contains(remoteUrl2));
        Assert.assertEquals((long)2L, (long)this.data.getRemoteUrls().size());
    }

    @Test
    public void testHasBeenReferenced() {
        Assert.assertTrue((boolean)this.data.hasBeenReferenced("git://github.com/jenkinsci/git-plugin.git"));
        Assert.assertFalse((boolean)this.data.hasBeenReferenced("git://github.com/jenkinsci/git-plugin.gitxxx"));
    }

    @Test
    public void testGetApi() {
        Api api = this.data.getApi();
        Api apiClone = this.data.clone().getApi();
        Assert.assertEquals((Object)api, (Object)api);
        Assert.assertEquals((Object)api.getSearchUrl(), (Object)apiClone.getSearchUrl());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)this.data.toString(), (Object)this.data.clone().toString());
        BuildData empty = new BuildData();
        Assert.assertTrue((String)("Wrong empty BuildData toString '" + empty.toString() + "'"), (boolean)empty.toString().endsWith("[scmName=<null>,remoteUrls=[],buildsByBranchName={},lastBuild=null]"));
    }

    @Test
    public void testEquals() {
        Object nullData = null;
        Assert.assertFalse((String)"Null object not equal non-null", (boolean)this.data.equals(nullData));
        Assert.assertEquals((String)"Object not equal itself", (Object)this.data, (Object)this.data);
        Assert.assertTrue((String)"Object not equal itself", (boolean)this.data.equals((Object)this.data));
        Assert.assertEquals((String)"Object hashCode not equal itself", (long)this.data.hashCode(), (long)this.data.hashCode());
        BuildData data1 = this.data.clone();
        Assert.assertEquals((String)"Cloned objects not equal", (Object)data1, (Object)this.data);
        Assert.assertTrue((String)"Cloned objects not equal", (boolean)data1.equals((Object)this.data));
        Assert.assertTrue((String)"Cloned objects not equal", (boolean)this.data.equals((Object)data1));
        Assert.assertEquals((String)"Cloned object hashCodes not equal", (long)this.data.hashCode(), (long)data1.hashCode());
        Revision revision1 = new Revision(this.sha1);
        Build build1 = new Build(revision1, 1, Result.SUCCESS);
        data1.saveBuild(build1);
        Assert.assertFalse((String)"Distinct objects shouldn't be equal", (boolean)this.data.equals((Object)data1));
        Assert.assertFalse((String)"Distinct objects shouldn't be equal", (boolean)data1.equals((Object)this.data));
        BuildData data2 = this.data.clone();
        data2.saveBuild(build1);
        Assert.assertTrue((String)"Objects with same saved build not equal", (boolean)data2.equals((Object)data1));
        Assert.assertTrue((String)"Objects with same saved build not equal", (boolean)data1.equals((Object)data2));
        Assert.assertEquals((String)"Objects with same saved build not equal hashCodes", (long)data2.hashCode(), (long)data1.hashCode());
        String remoteUrl2 = "git://github.com/jenkinsci/git-client-plugin.git";
        data1.addRemoteUrl("git://github.com/jenkinsci/git-client-plugin.git");
        Assert.assertFalse((String)"Distinct objects shouldn't be equal", (boolean)this.data.equals((Object)data1));
        Assert.assertFalse((String)"Distinct objects shouldn't be equal", (boolean)data1.equals((Object)this.data));
        data2.addRemoteUrl("git://github.com/jenkinsci/git-client-plugin.git");
        Assert.assertTrue((String)"Objects with same remote URL not equal", (boolean)data2.equals((Object)data1));
        Assert.assertTrue((String)"Objects with same remote URL not equal", (boolean)data1.equals((Object)data2));
        Assert.assertEquals((String)"Objects with same remote URL not equal hashCodes", (long)data2.hashCode(), (long)data1.hashCode());
        String branchName = "origin/master";
        ArrayList<Branch> branches = new ArrayList<Branch>();
        Branch branch = new Branch(branchName, this.sha1);
        branches.add(branch);
        Revision revision2 = new Revision(this.sha1, branches);
        Build build2 = new Build(revision2, 1, Result.FAILURE);
        Assert.assertEquals((Object)build1, (Object)build2);
        data1.saveBuild(build2);
        data2.saveBuild(build2);
        Assert.assertTrue((boolean)data1.equals((Object)data2));
        Assert.assertEquals((long)data1.hashCode(), (long)data2.hashCode());
        data1.saveBuild(build1);
        data2.saveBuild(build2);
        Assert.assertTrue((boolean)data1.equals((Object)data2));
        Assert.assertEquals((long)data1.hashCode(), (long)data2.hashCode());
        data1.setScmName("scm 1");
        Assert.assertTrue((boolean)data1.equals((Object)data2));
        Assert.assertEquals((long)data1.hashCode(), (long)data2.hashCode());
        data2.setScmName("scm 2");
        Assert.assertTrue((boolean)data1.equals((Object)data2));
        Assert.assertEquals((long)data1.hashCode(), (long)data2.hashCode());
    }
}

