/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import com.google.common.base.Function;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.DataBoundConstructor;

public class SparseCheckoutPath
extends AbstractDescribableImpl<SparseCheckoutPath>
implements Serializable {
    private static final long serialVersionUID = -6177158367915899356L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Default value is OK in deserialization")
    public static final transient SparseCheckoutPathToPath SPARSE_CHECKOUT_PATH_TO_PATH = new SparseCheckoutPathToPath();
    private final String path;

    @DataBoundConstructor
    public SparseCheckoutPath(String path) {
        this.path = path;
    }

    @Whitelisted
    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparseCheckoutPath that = (SparseCheckoutPath)o;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }

    public String toString() {
        return this.path;
    }

    public Descriptor<SparseCheckoutPath> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    private static class SparseCheckoutPathToPath
    implements Function<SparseCheckoutPath, String>,
    Serializable {
        private SparseCheckoutPathToPath() {
        }

        public String apply(@NonNull SparseCheckoutPath sparseCheckoutPath) {
            return sparseCheckoutPath.getPath();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SparseCheckoutPath> {
        public String getDisplayName() {
            return "Path";
        }
    }
}

