/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubClosable;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMFile;
import org.jenkinsci.plugins.github_branch_source.GitHubTagSCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
class GitHubSCMProbe
extends SCMProbe
implements GitHubClosable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(GitHubSCMProbe.class.getName());
    private final SCMRevision revision;
    private final transient GitHub gitHub;
    private final transient GHRepository repo;
    private final String ref;
    private final String name;
    private transient boolean open = true;

    public GitHubSCMProbe(String apiUri, StandardCredentials credentials, GHRepository repo, SCMHead head, SCMRevision revision) throws IOException {
        this.gitHub = Connector.connect(apiUri, credentials);
        this.revision = revision;
        this.repo = repo;
        this.name = head.getName();
        if (head instanceof PullRequestSCMHead) {
            PullRequestSCMHead pr = (PullRequestSCMHead)head;
            this.ref = "pull/" + pr.getNumber() + (pr.isMerge() ? "/merge" : "/head");
        } else {
            this.ref = head instanceof GitHubTagSCMHead ? "tags/" + head.getName() : "heads/" + head.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.gitHub == null || this.repo == null) {
            return;
        }
        GitHubSCMProbe gitHubSCMProbe = this;
        synchronized (gitHubSCMProbe) {
            if (!this.open) {
                return;
            }
            this.open = false;
        }
        Connector.release(this.gitHub);
    }

    private synchronized void checkOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Closed");
        }
        if (this.repo == null) {
            throw new IOException("No connection available");
        }
    }

    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastModified() {
        if (this.repo == null) {
            return 0L;
        }
        GitHubSCMProbe gitHubSCMProbe = this;
        synchronized (gitHubSCMProbe) {
            if (!this.open) {
                return 0L;
            }
        }
        if (this.revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            try {
                GHCommit commit = this.repo.getCommit(((AbstractGitSCMSource.SCMRevisionImpl)this.revision).getHash());
                return commit.getCommitDate().getTime();
            }
            catch (IOException commit) {}
        } else if (this.revision == null) {
            try {
                GHRef ref = this.repo.getRef(this.ref);
                GHCommit commit = this.repo.getCommit(ref.getObject().getSha());
                return commit.getCommitDate().getTime();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0L;
    }

    @NonNull
    public SCMProbeStat stat(@NonNull String path) throws IOException {
        this.checkOpen();
        try {
            int index = path.lastIndexOf(47) + 1;
            List directoryContent = this.repo.getDirectoryContent(path.substring(0, index), "refs/" + this.ref);
            for (GHContent content : directoryContent) {
                if (!content.getPath().equals(path)) continue;
                if (content.isFile()) {
                    return SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                }
                if (content.isDirectory()) {
                    return SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.DIRECTORY);
                }
                if ("symlink".equals(content.getType())) {
                    return SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.LINK);
                }
                return SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.OTHER);
            }
            for (GHContent content : directoryContent) {
                if (!content.getPath().equalsIgnoreCase(path)) continue;
                return SCMProbeStat.fromAlternativePath((String)content.getPath());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCMFile getRoot() {
        if (this.repo == null) {
            return null;
        }
        GitHubSCMProbe gitHubSCMProbe = this;
        synchronized (gitHubSCMProbe) {
            if (!this.open) {
                return null;
            }
        }
        String ref = this.revision != null ? (this.revision.getHead() instanceof PullRequestSCMHead ? this.ref : (this.revision instanceof AbstractGitSCMSource.SCMRevisionImpl ? ((AbstractGitSCMSource.SCMRevisionImpl)this.revision).getHash() : this.ref)) : this.ref;
        return new GitHubSCMFile(this, this.repo, ref);
    }

    @Override
    public synchronized boolean isOpen() {
        return this.open;
    }
}

