/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ui.icon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.IconType;

public class Icon {
    public static final String ICON_SMALL_STYLE = "width: 16px; height: 16px;";
    public static final String ICON_MEDIUM_STYLE = "width: 24px; height: 24px;";
    public static final String ICON_LARGE_STYLE = "width: 32px; height: 32px;";
    public static final String ICON_XLARGE_STYLE = "width: 48px; height: 48px;";
    private static final Map<String, String> iconDims = new HashMap<String, String>();
    private final String classSpec;
    private final String normalizedSelector;
    private final String url;
    private final String style;
    private IconType iconType;

    public Icon(String classSpec, String url, String style) {
        this(classSpec, url, style, IconType.CORE);
        if (url.startsWith("images/")) {
            this.iconType = IconType.CORE;
        } else if (url.startsWith("plugin/")) {
            this.iconType = IconType.PLUGIN;
        }
    }

    public Icon(String classSpec, String url, String style, IconType iconType) {
        this.classSpec = classSpec;
        this.normalizedSelector = Icon.toNormalizedCSSSelector(classSpec);
        this.url = Icon.toNormalizedIconUrl(url);
        this.style = style;
        this.iconType = iconType;
    }

    public String getClassSpec() {
        return this.classSpec;
    }

    public String getNormalizedSelector() {
        return this.normalizedSelector;
    }

    public String getUrl() {
        return this.url;
    }

    public String getQualifiedUrl(JellyContext context) {
        return this.iconType.toQualifiedUrl(this.url, context);
    }

    public String getStyle() {
        return this.style;
    }

    public static String toNormalizedIconNameClass(String string) {
        if (string == null) {
            return null;
        }
        return "icon-" + Icon.toNormalizedIconName(string);
    }

    public static String toNormalizedIconName(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith(".png") || string.endsWith(".gif")) {
            string = string.substring(0, string.length() - 4);
        }
        return string.replace("_", "-");
    }

    public static String toNormalizedIconSizeClass(String string) {
        if (string == null) {
            return null;
        }
        String normalizedSizeClass = iconDims.get(string.trim());
        return normalizedSizeClass != null ? normalizedSizeClass : string;
    }

    public static String toNormalizedCSSSelector(String classNames) {
        if (classNames == null) {
            return null;
        }
        String[] classNameTokA = classNames.split(" ");
        ArrayList<String> classNameTokL = new ArrayList<String>();
        for (int i = 0; i < classNameTokA.length; ++i) {
            String trimmedToken = classNameTokA[i].trim();
            if (trimmedToken.length() <= 0) continue;
            classNameTokL.add(trimmedToken);
        }
        classNameTokA = new String[classNameTokL.size()];
        classNameTokL.toArray(classNameTokA);
        Arrays.sort(classNameTokA, new StringComparator());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < classNameTokA.length; ++i) {
            stringBuilder.append(".").append(classNameTokA[i]);
        }
        return stringBuilder.toString();
    }

    public static String toNormalizedIconUrl(String url) {
        if (url == null) {
            return null;
        }
        String originalUrl = url;
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if (url.startsWith("images/")) {
            return url.substring("images/".length());
        }
        if (url.startsWith("plugin/")) {
            return url.substring("plugin/".length());
        }
        return originalUrl;
    }

    static {
        iconDims.put("16x16", "icon-sm");
        iconDims.put("24x24", "icon-md");
        iconDims.put("32x32", "icon-lg");
        iconDims.put("48x48", "icon-xlg");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }
}

