/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin;

import hudson.FilePath;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class WorkspaceUrlConnection
extends URLConnection {
    private final FilePath workspace;
    private InputStream is;

    public WorkspaceUrlConnection(URL url, FilePath workspace) {
        super(url);
        this.workspace = workspace;
    }

    @Override
    public void connect() throws IOException {
        String relativePath = this.url.getFile().substring(1);
        FilePath targetPath = this.workspace.child(relativePath);
        try {
            if (!targetPath.exists()) {
                throw new FileNotFoundException("Unable to find file at " + String.valueOf(targetPath));
            }
            this.is = targetPath.read();
            this.connected = true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }

    @Override
    public String getContentType() {
        return WorkspaceUrlConnection.guessContentTypeFromName(this.url.getFile());
    }
}

