/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.tools.ant.DirectoryScanner;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JUnitResultArchiver
extends Recorder
implements SimpleBuildStep {
    private final String testResults;
    private boolean keepLongStdio;
    private DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers;
    private Double healthScaleFactor;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public JUnitResultArchiver(String testResults) {
        this.testResults = testResults;
    }

    @Deprecated
    public JUnitResultArchiver(String testResults, DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers) {
        this(testResults, false, testDataPublishers);
    }

    @Deprecated
    public JUnitResultArchiver(String testResults, boolean keepLongStdio, DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers) {
        this(testResults, keepLongStdio, testDataPublishers, 1.0);
    }

    @Deprecated
    public JUnitResultArchiver(String testResults, boolean keepLongStdio, DescribableList<TestDataPublisher, Descriptor<TestDataPublisher>> testDataPublishers, double healthScaleFactor) {
        this.testResults = testResults;
        this.setKeepLongStdio(keepLongStdio);
        this.setTestDataPublishers(testDataPublishers == null ? Collections.emptyList() : testDataPublishers);
        this.setHealthScaleFactor(healthScaleFactor);
    }

    private TestResult parse(String expandedTestResults, Run<?, ?> run, @Nonnull FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return new JUnitParser(this.isKeepLongStdio()).parseResult(expandedTestResults, (Run)run, workspace, launcher, listener);
    }

    @Deprecated
    protected TestResult parse(String expandedTestResults, AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return this.parse(expandedTestResults, (Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Run build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        listener.getLogger().println(Messages.JUnitResultArchiver_Recording());
        String testResults = build.getEnvironment(listener).expand(this.testResults);
        TestResult result = this.parse(testResults, build, workspace, launcher, listener);
        Run run = build;
        synchronized (run) {
            boolean appending;
            TestResultAction action = (TestResultAction)build.getAction(TestResultAction.class);
            if (action == null) {
                appending = false;
                action = new TestResultAction(build, result, listener);
            } else {
                appending = true;
                action.mergeResult(result, listener);
            }
            action.setHealthScaleFactor(this.getHealthScaleFactor());
            if (result.isEmpty()) {
                if (build.getResult() == Result.FAILURE) {
                    return;
                }
                throw new AbortException(Messages.JUnitResultArchiver_ResultIsEmpty());
            }
            List<TestResultAction.Data> data = action.getData();
            if (this.testDataPublishers != null) {
                for (TestDataPublisher tdp : this.testDataPublishers) {
                    TestResultAction.Data d = tdp.contributeTestData(build, workspace, launcher, listener, result);
                    if (d == null) continue;
                    data.add(d);
                }
            }
            if (appending) {
                build.save();
            } else {
                build.addAction((Action)action);
            }
            if (action.getResult().getFailCount() > 0) {
                build.setResult(Result.UNSTABLE);
            }
        }
    }

    protected TestResult parseResult(DirectoryScanner ds, long buildTime) throws IOException {
        return new TestResult(buildTime, ds);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getTestResults() {
        return this.testResults;
    }

    public double getHealthScaleFactor() {
        return this.healthScaleFactor == null ? 1.0 : this.healthScaleFactor;
    }

    @DataBoundSetter
    public final void setHealthScaleFactor(double healthScaleFactor) {
        this.healthScaleFactor = Math.max(0.0, healthScaleFactor);
    }

    @Nonnull
    public List<? extends TestDataPublisher> getTestDataPublishers() {
        return this.testDataPublishers == null ? Collections.emptyList() : this.testDataPublishers;
    }

    @DataBoundSetter
    public final void setTestDataPublishers(@Nonnull List<? extends TestDataPublisher> testDataPublishers) {
        this.testDataPublishers = new DescribableList(Saveable.NOOP);
        this.testDataPublishers.addAll(testDataPublishers);
    }

    public boolean isKeepLongStdio() {
        return this.keepLongStdio;
    }

    @DataBoundSetter
    public final void setKeepLongStdio(boolean keepLongStdio) {
        this.keepLongStdio = keepLongStdio;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.JUnitResultArchiver_DisplayName();
        }

        public FormValidation doCheckTestResults(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (project == null) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckHealthScaleFactor(@QueryParameter double value) {
            if (value < 1.0E-7) {
                return FormValidation.warning((String)"Test health reporting disabled");
            }
            return FormValidation.ok((String)Messages.JUnitResultArchiver_HealthScaleFactorAnalysis(1, (int)(100.0 - Math.max(0.0, Math.min(100.0, 1.0 * value))), 5, (int)(100.0 - Math.max(0.0, Math.min(100.0, 5.0 * value)))));
        }
    }
}

