/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.AbortException;
import hudson.Util;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.PackageResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.MetaTabulatedResult;
import hudson.tasks.test.TestObject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.DirectoryScanner;
import org.dom4j.DocumentException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public final class TestResult
extends MetaTabulatedResult {
    private final List<SuiteResult> suites = new ArrayList<SuiteResult>();
    private transient Map<String, SuiteResult> suitesByName;
    private transient Map<String, PackageResult> byPackages;
    private transient AbstractTestResultAction parentAction;
    private transient TestObject parent;
    private transient int totalTests;
    private transient List<CaseResult> passedTests;
    private transient List<CaseResult> skippedTests;
    private transient int skippedTestsCounter;
    private float duration;
    private transient List<CaseResult> failedTests;
    private final boolean keepLongStdio;
    private static final long serialVersionUID = 1L;

    public TestResult() {
        this(false);
    }

    public TestResult(boolean keepLongStdio) {
        this.keepLongStdio = keepLongStdio;
    }

    @Deprecated
    public TestResult(long buildTime, DirectoryScanner results) throws IOException {
        this(buildTime, results, false);
    }

    public TestResult(long buildTime, DirectoryScanner results, boolean keepLongStdio) throws IOException {
        this.keepLongStdio = keepLongStdio;
        this.parse(buildTime, results);
    }

    @Override
    public TestObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TestObject parent) {
        this.parent = parent;
    }

    @Override
    public TestResult getTestResult() {
        return this;
    }

    public void parse(long buildTime, DirectoryScanner results) throws IOException {
        String[] includedFiles = results.getIncludedFiles();
        File baseDir = results.getBasedir();
        this.parse(buildTime, baseDir, includedFiles);
    }

    public void parse(long buildTime, File baseDir, String[] reportFiles) throws IOException {
        boolean parsed = false;
        for (String value : reportFiles) {
            File reportFile = new File(baseDir, value);
            if (buildTime - 3000L > reportFile.lastModified()) continue;
            this.parsePossiblyEmpty(reportFile);
            parsed = true;
        }
        if (!parsed) {
            long localTime = System.currentTimeMillis();
            if (localTime < buildTime - 1000L) {
                throw new AbortException("Clock on this slave is out of sync with the master, and therefore \nI can't figure out what test results are new and what are old.\nPlease keep the slave clock in sync with the master.");
            }
            File f = new File(baseDir, reportFiles[0]);
            throw new AbortException(String.format("Test reports were found but none of them are new. Did tests run? %nFor example, %s is %s old%n", f, Util.getTimeSpanString((long)(buildTime - f.lastModified()))));
        }
    }

    public void parse(long buildTime, Iterable<File> reportFiles) throws IOException {
        boolean parsed = false;
        for (File reportFile : reportFiles) {
            if (buildTime - 3000L > reportFile.lastModified()) continue;
            this.parsePossiblyEmpty(reportFile);
            parsed = true;
        }
        if (!parsed) {
            long localTime = System.currentTimeMillis();
            if (localTime < buildTime - 1000L) {
                throw new AbortException("Clock on this slave is out of sync with the master, and therefore \nI can't figure out what test results are new and what are old.\nPlease keep the slave clock in sync with the master.");
            }
            File f = reportFiles.iterator().next();
            throw new AbortException(String.format("Test reports were found but none of them are new. Did tests run? %nFor example, %s is %s old%n", f, Util.getTimeSpanString((long)(buildTime - f.lastModified()))));
        }
    }

    private void parsePossiblyEmpty(File reportFile) throws IOException {
        if (reportFile.length() == 0L) {
            SuiteResult sr = new SuiteResult(reportFile.getName(), "", "");
            sr.addCase(new CaseResult(sr, "[empty]", "Test report file " + reportFile.getAbsolutePath() + " was length 0"));
            this.add(sr);
        } else {
            this.parse(reportFile);
        }
    }

    private void add(SuiteResult sr) {
        for (SuiteResult s : this.suites) {
            if (!s.getName().equals(sr.getName()) || !this.nullSafeEq(s.getId(), sr.getId())) continue;
            if (this.strictEq(s.getTimestamp(), sr.getTimestamp())) {
                return;
            }
            for (CaseResult cr : sr.getCases()) {
                s.addCase(cr);
                cr.replaceParent(s);
            }
            this.duration += sr.getDuration();
            return;
        }
        this.suites.add(sr);
        this.duration += sr.getDuration();
    }

    void merge(TestResult other) {
        for (SuiteResult suite : other.suites) {
            suite.setParent(null);
            this.add(suite);
        }
        this.tally();
    }

    private boolean strictEq(Object lhs, Object rhs) {
        return lhs != null && rhs != null && lhs.equals(rhs);
    }

    private boolean nullSafeEq(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.equals(rhs);
    }

    public void parse(File reportFile) throws IOException {
        try {
            for (SuiteResult suiteResult : SuiteResult.parse(reportFile, this.keepLongStdio)) {
                this.add(suiteResult);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to read " + reportFile, e);
        }
        catch (RuntimeException e) {
            throw new IOException("Failed to read " + reportFile, e);
        }
        catch (DocumentException e) {
            if (!reportFile.getPath().endsWith(".xml")) {
                throw new IOException("Failed to read " + reportFile + "\nIs this really a JUnit report file? Your configuration must be matching too many files", e);
            }
            SuiteResult sr = new SuiteResult(reportFile.getName(), "", "");
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String error = "Failed to read test report file " + reportFile.getAbsolutePath() + "\n" + writer.toString();
            sr.addCase(new CaseResult(sr, "[failed-to-read]", error));
            this.add(sr);
        }
    }

    public String getDisplayName() {
        return Messages.TestResult_getDisplayName();
    }

    @Override
    public Run<?, ?> getRun() {
        return this.parentAction == null ? null : this.parentAction.run;
    }

    @Override
    public hudson.tasks.test.TestResult findCorrespondingResult(String id) {
        if (this.getId().equals(id) || id == null) {
            return this;
        }
        String firstElement = null;
        String subId = null;
        int sepIndex = id.indexOf(47);
        if (sepIndex < 0) {
            firstElement = id;
            subId = null;
        } else {
            firstElement = id.substring(0, sepIndex);
            subId = id.substring(sepIndex + 1);
            if (subId.length() == 0) {
                subId = null;
            }
        }
        String packageName = null;
        if (firstElement.equals(this.getId())) {
            sepIndex = subId.indexOf(47);
            if (sepIndex < 0) {
                packageName = subId;
                subId = null;
            } else {
                packageName = subId.substring(0, sepIndex);
                subId = subId.substring(sepIndex + 1);
            }
        } else {
            packageName = firstElement;
            subId = null;
        }
        PackageResult child = this.byPackage(packageName);
        if (child != null) {
            if (subId != null) {
                return child.findCorrespondingResult(subId);
            }
            return child;
        }
        return null;
    }

    @Override
    public String getTitle() {
        return Messages.TestResult_getTitle();
    }

    @Override
    public String getChildTitle() {
        return Messages.TestResult_getChildTitle();
    }

    @Override
    @Exported(visibility=999)
    public float getDuration() {
        return this.duration;
    }

    @Override
    @Exported(visibility=999)
    public int getPassCount() {
        return this.totalTests - this.getFailCount() - this.getSkipCount();
    }

    @Override
    @Exported(visibility=999)
    public int getFailCount() {
        if (this.failedTests == null) {
            return 0;
        }
        return this.failedTests.size();
    }

    @Override
    @Exported(visibility=999)
    public int getSkipCount() {
        return this.skippedTestsCounter;
    }

    @Exported(visibility=999)
    public boolean isEmpty() {
        return this.getTotalCount() == 0;
    }

    public List<CaseResult> getFailedTests() {
        return this.failedTests;
    }

    public synchronized List<CaseResult> getPassedTests() {
        if (this.passedTests == null) {
            this.passedTests = new ArrayList<CaseResult>();
            for (SuiteResult s : this.suites) {
                for (CaseResult cr : s.getCases()) {
                    if (!cr.isPassed()) continue;
                    this.passedTests.add(cr);
                }
            }
        }
        return this.passedTests;
    }

    public synchronized List<CaseResult> getSkippedTests() {
        if (this.skippedTests == null) {
            this.skippedTests = new ArrayList<CaseResult>();
            for (SuiteResult s : this.suites) {
                for (CaseResult cr : s.getCases()) {
                    if (!cr.isSkipped()) continue;
                    this.skippedTests.add(cr);
                }
            }
        }
        return this.skippedTests;
    }

    @Override
    public int getFailedSince() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Run<?, ?> getFailedSinceRun() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStdout() {
        StringBuilder sb = new StringBuilder();
        for (SuiteResult suite : this.suites) {
            sb.append("Standard Out (stdout) for Suite: " + suite.getName());
            sb.append(suite.getStdout());
        }
        return sb.toString();
    }

    @Override
    public String getStderr() {
        StringBuilder sb = new StringBuilder();
        for (SuiteResult suite : this.suites) {
            sb.append("Standard Error (stderr) for Suite: " + suite.getName());
            sb.append(suite.getStderr());
        }
        return sb.toString();
    }

    @Override
    public String getErrorStackTrace() {
        return "No error stack traces available at this level. Drill down to individual tests to find stack traces.";
    }

    @Override
    public String getErrorDetails() {
        return "No error details available at this level. Drill down to individual tests to find details.";
    }

    @Override
    public boolean isPassed() {
        return this.getFailCount() == 0;
    }

    public Collection<PackageResult> getChildren() {
        return this.byPackages.values();
    }

    @Override
    public boolean hasChildren() {
        return !this.suites.isEmpty();
    }

    @Exported(inline=true, visibility=9)
    public Collection<SuiteResult> getSuites() {
        return this.suites;
    }

    @Override
    public String getName() {
        return "junit";
    }

    @Override
    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (token.equals(this.getId())) {
            return this;
        }
        PackageResult result = this.byPackage(token);
        if (result != null) {
            return result;
        }
        return super.getDynamic(token, req, rsp);
    }

    public PackageResult byPackage(String packageName) {
        return this.byPackages.get(packageName);
    }

    public SuiteResult getSuite(String name) {
        return this.suitesByName.get(name);
    }

    @Override
    public void setParentAction(AbstractTestResultAction action) {
        this.parentAction = action;
        this.tally();
    }

    @Override
    public AbstractTestResultAction getParentAction() {
        return this.parentAction;
    }

    @Override
    public void tally() {
        this.suitesByName = new HashMap<String, SuiteResult>();
        this.failedTests = new ArrayList<CaseResult>();
        this.skippedTests = null;
        this.passedTests = null;
        this.byPackages = new TreeMap<String, PackageResult>();
        this.totalTests = 0;
        this.skippedTestsCounter = 0;
        for (SuiteResult s : this.suites) {
            s.setParent(this);
            this.suitesByName.put(s.getName(), s);
            List<CaseResult> cases = s.getCases();
            for (CaseResult cr : cases) {
                cr.setParentAction(this.parentAction);
                cr.setParentSuiteResult(s);
                cr.tally();
                String pkg = cr.getPackageName();
                String spkg = TestResult.safe(pkg);
                PackageResult pr = this.byPackage(spkg);
                if (pr == null) {
                    pr = new PackageResult(this, pkg);
                    this.byPackages.put(spkg, pr);
                }
                pr.add(cr);
            }
        }
        for (PackageResult pr : this.byPackages.values()) {
            pr.tally();
            this.skippedTestsCounter += pr.getSkipCount();
            this.failedTests.addAll(pr.getFailedTests());
            this.totalTests += pr.getTotalCount();
        }
    }

    public void freeze(TestResultAction parent) {
        this.parentAction = parent;
        if (this.suitesByName == null) {
            this.suitesByName = new HashMap<String, SuiteResult>();
            this.totalTests = 0;
            this.failedTests = new ArrayList<CaseResult>();
            this.skippedTests = null;
            this.passedTests = null;
            this.byPackages = new TreeMap<String, PackageResult>();
        }
        for (SuiteResult s : this.suites) {
            if (!s.freeze(this)) continue;
            this.suitesByName.put(s.getName(), s);
            this.totalTests += s.getCases().size();
            for (CaseResult cr : s.getCases()) {
                String pkg;
                String spkg;
                PackageResult pr;
                if (cr.isSkipped()) {
                    ++this.skippedTestsCounter;
                    if (this.skippedTests != null) {
                        this.skippedTests.add(cr);
                    }
                } else if (!cr.isPassed()) {
                    this.failedTests.add(cr);
                } else if (this.passedTests != null) {
                    this.passedTests.add(cr);
                }
                if ((pr = this.byPackage(spkg = TestResult.safe(pkg = cr.getPackageName()))) == null) {
                    pr = new PackageResult(this, pkg);
                    this.byPackages.put(spkg, pr);
                }
                pr.add(cr);
            }
        }
        Collections.sort(this.failedTests, CaseResult.BY_AGE);
        if (this.passedTests != null) {
            Collections.sort(this.passedTests, CaseResult.BY_AGE);
        }
        if (this.skippedTests != null) {
            Collections.sort(this.skippedTests, CaseResult.BY_AGE);
        }
        for (PackageResult pr : this.byPackages.values()) {
            pr.freeze();
        }
    }
}

