/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.echarts.BuildResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import hudson.tasks.junit.HistoryTestResultSummary;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class TestObjectIterable
implements Iterable<BuildResult<TestObject>> {
    private final TestObject latestAction;
    private final List<TestObject> items;

    public TestObjectIterable(TestObject baseline) {
        this.latestAction = baseline;
        this.items = null;
    }

    public TestObjectIterable(TestObject baseline, List<HistoryTestResultSummary> results) {
        this.latestAction = baseline;
        this.items = results.stream().map(r -> baseline.getResultInRun((Run)r.getRun())).filter(r -> r != null).collect(Collectors.toList());
    }

    @Override
    @NonNull
    public Iterator<BuildResult<TestObject>> iterator() {
        if (this.items == null) {
            return new TestResultActionIterator(this.latestAction);
        }
        return this.items.stream().map(t -> {
            Run<?, ?> run = t.getRun();
            int buildTimeInSeconds = (int)(run.getTimeInMillis() / 1000L);
            Build build = new Build(run.getNumber(), run.getDisplayName(), buildTimeInSeconds);
            return new BuildResult(build, t);
        }).collect(Collectors.toList()).iterator();
    }

    private static class TestResultActionIterator
    implements Iterator<BuildResult<TestObject>> {
        private TestObject cursor;
        private TestObject initialValue;

        TestResultActionIterator(TestObject baseline) {
            this.initialValue = baseline;
        }

        @Override
        public boolean hasNext() {
            if (this.initialValue != null) {
                return true;
            }
            if (this.cursor == null) {
                return false;
            }
            TestResult previousBuild = this.cursor.getPreviousResult();
            return previousBuild != null;
        }

        @Override
        public BuildResult<TestObject> next() {
            if (this.initialValue == null && this.cursor == null) {
                throw new NoSuchElementException("There is no action available anymore. Use hasNext() before calling next().");
            }
            TestObject testResult = this.getTestResult();
            if (testResult != null) {
                this.cursor = testResult;
                Run<?, ?> run = this.cursor.getRun();
                int buildTimeInSeconds = (int)(run.getTimeInMillis() / 1000L);
                Build build = new Build(run.getNumber(), run.getDisplayName(), buildTimeInSeconds);
                return new BuildResult(build, (Object)testResult);
            }
            throw new NoSuchElementException("No more runs with a test result available: " + this.cursor);
        }

        private TestObject getTestResult() {
            TestObject run;
            if (this.initialValue != null) {
                run = this.initialValue;
                this.initialValue = null;
            } else {
                run = this.cursor.getPreviousResult();
            }
            return run;
        }
    }
}

