/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

@Restricted(value={NoExternalUse.class})
class ValidationUtil {
    private ValidationUtil() {
    }

    static String formatNonExistentUserGroupValidationResponse(String user, String tooltip) {
        return ValidationUtil.formatUserGroupValidationResponse("user-disabled.png", "<span style='text-decoration: line-through; color: grey;'>" + user + "</span>", tooltip, true);
    }

    static String formatUserGroupValidationResponse(String img, String user, String tooltip, boolean inPlugin) {
        if (inPlugin) {
            return String.format("<span title='%s'><img src='%s/plugin/matrix-auth/images/%s' style='margin-right:0.2em'>%s</span>", tooltip, Stapler.getCurrentRequest().getContextPath(), img, user);
        }
        return String.format("<span title='%s'><img src='%s%s/images/16x16/%s' style='margin-right:0.2em'>%s</span>", tooltip, Stapler.getCurrentRequest().getContextPath(), Jenkins.RESOURCE_PATH, img, user);
    }
}

