/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.inheritance;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategyDescriptor;
import org.jenkinsci.plugins.matrixauth.inheritance.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class InheritParentStrategy
extends InheritanceStrategy {
    @DataBoundConstructor
    public InheritParentStrategy() {
    }

    @Override
    public ACL getEffectiveACL(ACL acl, AccessControlled subject) {
        if (subject instanceof AbstractItem) {
            AbstractItem item = (AbstractItem)subject;
            ItemGroup parent = item.getParent();
            ACL parentACL = parent instanceof AbstractItem ? Jenkins.get().getAuthorizationStrategy().getACL((AbstractItem)parent) : Jenkins.get().getAuthorizationStrategy().getRootACL();
            return ProjectMatrixAuthorizationStrategy.inheritingACL(parentACL, acl);
        }
        throw new IllegalArgumentException("Expected subject to be AbstractItem, but got " + subject);
    }

    @Symbol(value={"inheriting"})
    @Extension(ordinal=100.0)
    public static class DescriptorImpl
    extends InheritanceStrategyDescriptor {
        @Override
        public boolean isApplicable(Class<?> clazz) {
            return AbstractItem.class.isAssignableFrom(clazz);
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.InheritParentStrategy_DisplayName();
        }
    }
}

