/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.XStream;
import hudson.Util;
import hudson.matrix.Axis;
import hudson.matrix.Combination;
import hudson.util.RobustCollectionConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

public class AxisList
extends ArrayList<Axis> {
    public AxisList() {
    }

    public AxisList(Collection<? extends Axis> c) {
        super(c);
    }

    public AxisList(Axis ... c) {
        this((Collection<? extends Axis>)Arrays.asList(c));
    }

    public Axis find(String name) {
        for (Axis a : this) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public AxisList subList(Class<? extends Axis> subType) {
        return new AxisList(Util.filter((List)this, subType));
    }

    @Override
    public boolean add(Axis axis) {
        return axis != null && super.add(axis);
    }

    public Iterable<Combination> list() {
        ArrayList axesList = Lists.newArrayList();
        for (Axis axis : this) {
            axesList.add(new LinkedHashSet<String>(axis.getValues()));
        }
        return Iterables.transform((Iterable)Sets.cartesianProduct((List)axesList), (Function)new Function<List<String>, Combination>(){

            public Combination apply(@Nullable List<String> strings) {
                assert (strings != null);
                return new Combination(AxisList.this, strings);
            }
        });
    }

    public static final class ConverterImpl
    extends RobustCollectionConverter {
        public ConverterImpl(XStream xs) {
            super(xs);
        }

        public boolean canConvert(Class type) {
            return type == AxisList.class;
        }

        protected Object createCollection(Class type) {
            return new AxisList();
        }
    }
}

