/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import groovy.lang.GroovyRuntimeException;
import hudson.AbortException;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.matrix.Combination;
import hudson.matrix.FilterScript;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixChildAction;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixConfigurationSorter;
import hudson.matrix.MatrixExecutionStrategy;
import hudson.matrix.MatrixExecutionStrategyDescriptor;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.matrix.Messages;
import hudson.matrix.listeners.MatrixBuildListener;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultMatrixExecutionStrategyImpl
extends MatrixExecutionStrategy {
    private volatile boolean runSequentially;
    private volatile String touchStoneCombinationFilter;
    private volatile Result touchStoneResultCondition;
    private volatile MatrixConfigurationSorter sorter;

    @DataBoundConstructor
    public DefaultMatrixExecutionStrategyImpl(Boolean runSequentially, boolean hasTouchStoneCombinationFilter, String touchStoneCombinationFilter, Result touchStoneResultCondition, MatrixConfigurationSorter sorter) {
        this(runSequentially != null ? runSequentially : false, hasTouchStoneCombinationFilter ? touchStoneCombinationFilter : null, (Result)(hasTouchStoneCombinationFilter ? touchStoneResultCondition : null), sorter);
    }

    public DefaultMatrixExecutionStrategyImpl(boolean runSequentially, String touchStoneCombinationFilter, Result touchStoneResultCondition, MatrixConfigurationSorter sorter) {
        this.runSequentially = runSequentially;
        this.touchStoneCombinationFilter = touchStoneCombinationFilter;
        this.touchStoneResultCondition = touchStoneResultCondition;
        this.sorter = sorter;
    }

    public DefaultMatrixExecutionStrategyImpl() {
        this(false, false, null, null, null);
    }

    public boolean getHasTouchStoneCombinationFilter() {
        return this.touchStoneCombinationFilter != null;
    }

    public boolean isRunSequentially() {
        return this.runSequentially;
    }

    public void setRunSequentially(boolean runSequentially) {
        this.runSequentially = runSequentially;
    }

    public String getTouchStoneCombinationFilter() {
        return this.touchStoneCombinationFilter;
    }

    public void setTouchStoneCombinationFilter(String touchStoneCombinationFilter) {
        this.touchStoneCombinationFilter = touchStoneCombinationFilter;
    }

    public Result getTouchStoneResultCondition() {
        return this.touchStoneResultCondition;
    }

    public void setTouchStoneResultCondition(Result touchStoneResultCondition) {
        this.touchStoneResultCondition = touchStoneResultCondition;
    }

    public MatrixConfigurationSorter getSorter() {
        return this.sorter;
    }

    public void setSorter(MatrixConfigurationSorter sorter) {
        this.sorter = sorter;
    }

    @Override
    public Result run(MatrixBuild.MatrixBuildExecution execution) throws InterruptedException, IOException {
        MatrixRun run;
        AbstractSet touchStoneConfigurations = new HashSet<MatrixConfiguration>();
        AbstractSet delayedConfigurations = new HashSet<MatrixConfiguration>();
        this.filterConfigurations(execution, touchStoneConfigurations, delayedConfigurations);
        if (this.notifyStartBuild(execution.getAggregators())) {
            return Result.FAILURE;
        }
        if (this.sorter != null) {
            touchStoneConfigurations = this.createTreeSet(touchStoneConfigurations, this.sorter);
            delayedConfigurations = this.createTreeSet(delayedConfigurations, this.sorter);
        }
        if (!this.runSequentially) {
            for (MatrixConfiguration c : touchStoneConfigurations) {
                this.scheduleConfigurationBuild(execution, c);
            }
        }
        PrintStream logger = execution.getListener().getLogger();
        Result r = Result.SUCCESS;
        for (MatrixConfiguration c : touchStoneConfigurations) {
            if (this.runSequentially) {
                this.scheduleConfigurationBuild(execution, c);
            }
            run = this.waitForCompletion(execution, c);
            this.notifyEndBuild(run, execution.getAggregators());
            logger.println(Messages.MatrixBuild_Completed(ModelHyperlinkNote.encodeTo((Item)c), this.getResult(run)));
            r = r.combine(this.getResult(run));
        }
        if (this.touchStoneResultCondition != null && r.isWorseThan(this.touchStoneResultCondition)) {
            logger.printf("Touchstone configurations resulted in %s, so aborting...%n", r);
            return r;
        }
        if (!this.runSequentially) {
            for (MatrixConfiguration c : delayedConfigurations) {
                this.scheduleConfigurationBuild(execution, c);
            }
        }
        for (MatrixConfiguration c : delayedConfigurations) {
            if (this.runSequentially) {
                this.scheduleConfigurationBuild(execution, c);
            }
            run = this.waitForCompletion(execution, c);
            this.notifyEndBuild(run, execution.getAggregators());
            logger.println(Messages.MatrixBuild_Completed(ModelHyperlinkNote.encodeTo((Item)c), this.getResult(run)));
            r = r.combine(this.getResult(run));
        }
        return r;
    }

    private void filterConfigurations(MatrixBuild.MatrixBuildExecution execution, Collection<MatrixConfiguration> touchStoneConfigurations, Collection<MatrixConfiguration> delayedConfigurations) throws AbortException {
        MatrixBuild build = (MatrixBuild)execution.getBuild();
        FilterScript combinationFilter = FilterScript.parse(((MatrixProject)execution.getProject()).getCombinationFilter(), FilterScript.ACCEPT_ALL);
        FilterScript touchStoneFilter = FilterScript.parse(this.getTouchStoneCombinationFilter(), FilterScript.REJECT_ALL);
        try {
            for (MatrixConfiguration c : execution.getActiveConfigurations()) {
                if (!MatrixBuildListener.buildConfiguration(build, c)) continue;
                Combination combination = c.getCombination();
                if (touchStoneFilter != null && touchStoneFilter.apply(execution, combination)) {
                    touchStoneConfigurations.add(c);
                    continue;
                }
                if (!combinationFilter.apply(execution, combination)) continue;
                delayedConfigurations.add(c);
            }
        }
        catch (GroovyRuntimeException ex) {
            PrintStream logger = execution.getListener().getLogger();
            logger.println(ex.getMessage());
            ex.printStackTrace(logger);
            throw new AbortException("Failed executing combination filter");
        }
    }

    private Result getResult(@Nullable MatrixRun run) {
        return run != null ? run.getResult() : Result.ABORTED;
    }

    private boolean notifyStartBuild(List<MatrixAggregator> aggregators) throws InterruptedException, IOException {
        for (MatrixAggregator a : aggregators) {
            if (a.startBuild()) continue;
            return true;
        }
        return false;
    }

    private void notifyEndBuild(MatrixRun b, List<MatrixAggregator> aggregators) throws InterruptedException, IOException {
        if (b == null) {
            return;
        }
        for (MatrixAggregator a : aggregators) {
            if (a.endRun(b)) continue;
            throw new AbortException();
        }
    }

    private <T> TreeSet<T> createTreeSet(Collection<T> items, Comparator<T> sorter) {
        TreeSet<T> r = new TreeSet<T>(sorter);
        r.addAll(items);
        return r;
    }

    private void scheduleConfigurationBuild(MatrixBuild.MatrixBuildExecution exec, MatrixConfiguration c) {
        MatrixBuild build = (MatrixBuild)exec.getBuild();
        exec.getListener().getLogger().println(Messages.MatrixBuild_Triggering(ModelHyperlinkNote.encodeTo((Item)c)));
        ArrayList childActions = new ArrayList(build.getActions(MatrixChildAction.class));
        childActions.addAll(build.getActions(ParametersAction.class));
        c.scheduleBuild(childActions, (Cause)new Cause.UpstreamCause((Run)build));
    }

    private MatrixRun waitForCompletion(MatrixBuild.MatrixBuildExecution exec, MatrixConfiguration c) throws InterruptedException, IOException {
        BuildListener listener = exec.getListener();
        String whyInQueue = "";
        long startTime = System.currentTimeMillis();
        int appearsCancelledCount = 0;
        Result buildResult;
        MatrixRun b;
        while ((b = (MatrixRun)c.getBuildByNumber(((MatrixBuild)exec.getBuild()).getNumber())) == null || b.isBuilding() || (buildResult = b.getResult()) == null) {
            String why;
            Queue.Item qi = c.getQueueItem();
            appearsCancelledCount = b == null && qi == null ? ++appearsCancelledCount : 0;
            if (appearsCancelledCount >= 5) {
                listener.getLogger().println(Messages.MatrixBuild_AppearsCancelled(ModelHyperlinkNote.encodeTo((Item)c)));
                return null;
            }
            if (qi != null && (why = qi.getWhy()) != null && !why.equals(whyInQueue) && System.currentTimeMillis() - startTime > 5000L) {
                listener.getLogger().print("Configuration " + ModelHyperlinkNote.encodeTo((Item)c) + " is still in the queue: ");
                qi.getCauseOfBlockage().print((TaskListener)listener);
                whyInQueue = why;
            }
            Thread.sleep(1000L);
        }
        return b;
    }

    @Extension
    public static class DescriptorImpl
    extends MatrixExecutionStrategyDescriptor {
        public String getDisplayName() {
            return "Classic";
        }
    }
}

