/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Queue;
import hudson.model.Run;
import java.util.Optional;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;

public abstract class RunResolver
implements ExtensionPoint {
    @CheckForNull
    protected abstract Run<?, ?> runOf(@NonNull Queue.Executable var1);

    @NonNull
    public static Optional<Run<?, ?>> resolve(@NonNull Queue.Executable executable) {
        for (RunResolver r : ExtensionList.lookup(RunResolver.class)) {
            Run<?, ?> run = r.runOf(executable);
            if (run == null) continue;
            return Optional.of(run);
        }
        return Optional.empty();
    }

    @OptionalExtension(requireClasses={ExecutorStepExecution.PlaceholderTask.class})
    public static class WorkflowPlaceholderTask
    extends RunResolver {
        @Override
        protected Run<?, ?> runOf(@NonNull Queue.Executable executable) {
            if (executable.getParent() instanceof ExecutorStepExecution.PlaceholderTask) {
                return ((ExecutorStepExecution.PlaceholderTask)executable.getParent()).run();
            }
            return null;
        }
    }

    @Extension
    public static class ImplementsRun
    extends RunResolver {
        @Override
        protected Run<?, ?> runOf(@NonNull Queue.Executable executable) {
            if (executable instanceof Run) {
                return (Run)executable;
            }
            return null;
        }
    }
}

