/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Item;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.security.access.AccessDeniedException;

public final class DownstreamBuildAction
extends InvisibleAction {
    private final List<DownstreamBuild> downstreamBuilds = new ArrayList<DownstreamBuild>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static DownstreamBuild getOrCreate(@NonNull Run<?, ?> run, @NonNull String flowNodeId, @NonNull Item job) {
        Class<DownstreamBuildAction> clazz = DownstreamBuildAction.class;
        synchronized (DownstreamBuildAction.class) {
            DownstreamBuildAction downstreamBuildAction = (DownstreamBuildAction)run.getAction(DownstreamBuildAction.class);
            if (downstreamBuildAction == null) {
                downstreamBuildAction = new DownstreamBuildAction();
                run.addAction((Action)downstreamBuildAction);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return downstreamBuildAction.getOrAddDownstreamBuild(flowNodeId, job);
        }
    }

    @NonNull
    public synchronized List<DownstreamBuild> getDownstreamBuilds() {
        return Collections.unmodifiableList(new ArrayList<DownstreamBuild>(this.downstreamBuilds));
    }

    @NonNull
    private synchronized DownstreamBuild getOrAddDownstreamBuild(@NonNull String flowNodeId, @NonNull Item job) {
        for (DownstreamBuild build : this.downstreamBuilds) {
            if (!build.getFlowNodeId().equals(flowNodeId)) continue;
            return build;
        }
        DownstreamBuild build = new DownstreamBuild(flowNodeId, job);
        this.downstreamBuilds.add(build);
        return build;
    }

    public static final class DownstreamBuild {
        private final String flowNodeId;
        private final String jobFullName;
        private Integer buildNumber;

        DownstreamBuild(String flowNodeId, @NonNull Item job) {
            this.flowNodeId = flowNodeId;
            this.jobFullName = job.getFullName();
        }

        @NonNull
        public String getFlowNodeId() {
            return this.flowNodeId;
        }

        @NonNull
        public String getJobFullName() {
            return this.jobFullName;
        }

        @CheckForNull
        public Integer getBuildNumber() {
            return this.buildNumber;
        }

        @CheckForNull
        public Run<?, ?> getBuild() throws AccessDeniedException {
            if (this.buildNumber == null) {
                return null;
            }
            return Run.fromExternalizableId((String)(this.jobFullName + "#" + this.buildNumber));
        }

        void setBuild(@NonNull Run<?, ?> run) {
            this.buildNumber = run.getNumber();
        }
    }
}

