/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import hudson.AbortException;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.build.DownstreamFailureCause;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;
import org.jenkinsci.plugins.workflow.support.steps.build.WaitForBuildAction;

@Extension
public class WaitForBuildListener
extends RunListener<Run<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(WaitForBuildListener.class.getName());

    public void onFinalized(Run<?, ?> run) {
        for (WaitForBuildAction action : run.getActions(WaitForBuildAction.class)) {
            StepContext context = action.context;
            LOGGER.log(Level.FINE, "completing {0} for {1}", new Object[]{run, context});
            Result result = run.getResult();
            if (result == null) {
                result = Result.FAILURE;
            }
            try {
                ((TaskListener)context.get(TaskListener.class)).getLogger().println("Build " + ModelHyperlinkNote.encodeTo((String)("/" + run.getUrl()), (String)run.getFullDisplayName()) + " completed: " + result.toString());
                if (action.propagate && result.isWorseThan(Result.SUCCESS)) {
                    ((FlowNode)context.get(FlowNode.class)).addOrReplaceAction((Action)new WarningAction(result));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, null, e);
            }
            if (!action.propagate || result == Result.SUCCESS) {
                context.onSuccess((Object)new RunWrapper(run, false));
                continue;
            }
            context.onFailure((Throwable)new FlowInterruptedException(result, false, new CauseOfInterruption[]{new DownstreamFailureCause(run)}));
        }
        run.removeActions(WaitForBuildAction.class);
    }

    public void onDeleted(Run<?, ?> run) {
        for (WaitForBuildAction action : run.getActions(WaitForBuildAction.class)) {
            Timer.get().submit(() -> action.context.onFailure((Throwable)new AbortException(run.getFullDisplayName() + " was deleted")));
        }
    }
}

