/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.input;

import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.FileParameterDefinition;
import hudson.model.ParameterDefinition;
import hudson.model.PasswordParameterDefinition;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.jenkinsci.plugins.structs.describable.CustomDescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.jenkinsci.plugins.workflow.support.steps.input.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public class InputStep
extends AbstractStepImpl
implements Serializable {
    private static final boolean ALLOW_POTENTIALLY_UNSAFE_IDS = SystemProperties.getBoolean((String)(InputStep.class.getName() + ".ALLOW_UNSAFE_IDS"));
    private final String message;
    private String id;
    private String submitter;
    private String submitterParameter;
    private List<ParameterDefinition> parameters = Collections.emptyList();
    private String cancel;
    private String ok;

    @DataBoundConstructor
    public InputStep(String message) {
        super(true);
        if (message == null) {
            message = "Pipeline has paused and needs your input before proceeding";
        }
        this.message = message;
    }

    @DataBoundSetter
    public void setId(String id) {
        String _id = this.capitalize(Util.fixEmpty((String)id));
        if (this.isIdConsideredUnsafe(_id)) {
            throw new IllegalArgumentException("InputStep id is required to be URL safe, but the provided id " + _id + " is not safe");
        }
        this.id = _id;
    }

    @Exported
    public String getId() {
        if (this.id == null) {
            this.id = this.capitalize(Util.getDigestOf((String)this.message));
        }
        return this.id;
    }

    @Exported
    public String getSubmitter() {
        return this.submitter;
    }

    @DataBoundSetter
    public void setSubmitter(String submitter) {
        this.submitter = Util.fixEmptyAndTrim((String)submitter);
    }

    @Exported
    public String getSubmitterParameter() {
        return this.submitterParameter;
    }

    @DataBoundSetter
    public void setSubmitterParameter(String submitterParameter) {
        this.submitterParameter = Util.fixEmptyAndTrim((String)submitterParameter);
    }

    private String capitalize(String id) {
        if (id == null) {
            return null;
        }
        if (((String)id).length() == 0) {
            throw new IllegalArgumentException();
        }
        char ch = ((String)id).charAt(0);
        if ('a' <= ch && ch <= 'z') {
            id = (char)(ch - 97 + 65) + ((String)id).substring(1);
        }
        return id;
    }

    @Exported
    public String getCancel() {
        return this.cancel != null ? this.cancel : Messages.abort();
    }

    @DataBoundSetter
    public void setCancel(String cancel) {
        this.cancel = Util.fixEmptyAndTrim((String)cancel);
    }

    @Exported
    public String getOk() {
        return this.ok != null ? this.ok : Messages.proceed();
    }

    @DataBoundSetter
    public void setOk(String ok) {
        this.ok = Util.fixEmptyAndTrim((String)ok);
    }

    @Exported
    public List<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    @DataBoundSetter
    public void setParameters(List<ParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    @Exported
    public String getMessage() {
        return this.message;
    }

    @Deprecated
    public boolean canSubmit() {
        Authentication a = Jenkins.getAuthentication();
        return this.canSettle(a);
    }

    @Deprecated
    public boolean canSettle(Authentication a) {
        if (this.submitter == null) {
            return true;
        }
        HashSet submitters = new HashSet();
        Collections.addAll(submitters, this.submitter.split(","));
        if (submitters.contains(a.getName())) {
            return true;
        }
        for (GrantedAuthority ga : a.getAuthorities()) {
            if (!submitters.contains(ga.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new InputStepExecution(this, context);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private boolean isIdConsideredUnsafe(String potentialId) {
        if (ALLOW_POTENTIALLY_UNSAFE_IDS) {
            return false;
        }
        return !this.getDescriptor().doCheckId((String)potentialId).kind.equals((Object)FormValidation.Kind.OK);
    }

    private Object readResolve() throws AbortException {
        if (this.isIdConsideredUnsafe(this.id)) {
            throw new AbortException("InputStep id is required to be URL safe, but the provided id " + this.id + " is not safe");
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor
    implements CustomDescribableModel {
        public String getFunctionName() {
            return "input";
        }

        public String getDisplayName() {
            return Messages.wait_for_interactive_input();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, Run.class, TaskListener.class, FlowNode.class);
            return Collections.unmodifiableSet(context);
        }

        public Map<String, Object> customInstantiate(Map<String, Object> map) {
            if (DescribableModel.of(PasswordParameterDefinition.class).getParameter("defaultValue") != null) {
                return map;
            }
            return DescriptorImpl.copyMapReplacingEntry(map, "parameters", "parameters", List.class, parameters -> parameters.stream().map(parameter -> {
                UninstantiatedDescribable ud;
                if (parameter instanceof UninstantiatedDescribable && null != (ud = (UninstantiatedDescribable)parameter).getSymbol() && ud.getSymbol().equals("password")) {
                    Map<String, Object> newArguments = DescriptorImpl.copyMapReplacingEntry(ud.getArguments(), "defaultValue", "defaultValueAsSecret", String.class, Secret::fromString);
                    return ud.withArguments(newArguments);
                }
                return parameter;
            }).collect(Collectors.toList()));
        }

        public UninstantiatedDescribable customUninstantiate(UninstantiatedDescribable step) {
            if (DescribableModel.of(PasswordParameterDefinition.class).getParameter("defaultValue") != null) {
                return step;
            }
            Map<String, Object> newStepArgs = DescriptorImpl.copyMapReplacingEntry(step.getArguments(), "parameters", "parameters", List.class, parameters -> parameters.stream().map(parameter -> {
                UninstantiatedDescribable ud;
                if (parameter instanceof UninstantiatedDescribable && (ud = (UninstantiatedDescribable)parameter).getSymbol().equals("password")) {
                    Map<String, Object> newParamArgs = DescriptorImpl.copyMapReplacingEntry(ud.getArguments(), "defaultValueAsSecret", "defaultValue", Secret.class, Secret::getPlainText);
                    return ud.withArguments(newParamArgs);
                }
                return parameter;
            }).collect(Collectors.toList()));
            return step.withArguments(newStepArgs);
        }

        private static <T> Map<String, Object> copyMapReplacingEntry(Map<String, ?> map, String oldKey, String newKey, Class<T> requiredValueType, Function<T, Object> replacer) {
            TreeMap<String, Object> newMap = new TreeMap<String, Object>();
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (entry.getKey().equals(oldKey) && requiredValueType.isInstance(entry.getValue())) {
                    newMap.put(newKey, replacer.apply(requiredValueType.cast(entry.getValue())));
                    continue;
                }
                newMap.put(entry.getKey(), entry.getValue());
            }
            return newMap;
        }

        public List<ParameterDefinition.ParameterDescriptor> getParametersDescriptors() {
            return ExtensionList.lookup(ParameterDefinition.ParameterDescriptor.class).stream().filter(descriptor -> descriptor.clazz != FileParameterDefinition.class).collect(Collectors.toList());
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckId(@QueryParameter String id) {
            if (id == null || id.isEmpty()) {
                return FormValidation.ok();
            }
            if (id.equals(".")) {
                return FormValidation.error((String)"The ID is required to be URL safe and is limited to the characters a-z A-Z, the digits 0-9 and additionally the characters ':' '@' '=' '+' '$' ',' '-' '_' '.' '!' '~' '*' '(' ')'.");
            }
            if (id.equals("..")) {
                return FormValidation.error((String)"The ID is required to be URL safe and is limited to the characters a-z A-Z, the digits 0-9 and additionally the characters ':' '@' '=' '+' '$' ',' '-' '_' '.' '!' '~' '*' '(' ')'.");
            }
            if (!id.matches("^[a-zA-Z0-9[-]._~!$()*+,:@=]+$")) {
                return FormValidation.error((String)"The ID is required to be URL safe and is limited to the characters a-z A-Z, the digits 0-9 and additionally the characters ':' '@' '=' '+' '$' ',' '-' '_' '.' '!' '~' '*' '(' ')'.");
            }
            return FormValidation.ok();
        }
    }
}

