/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.input;

import com.cloudbees.plugins.credentials.CredentialsParameterValue;
import com.cloudbees.plugins.credentials.builds.CredentialsParameterBinder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Action;
import hudson.model.Failure;
import hudson.model.FileParameterDefinition;
import hudson.model.FileParameterValue;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import io.jenkins.servlet.ServletExceptionWrapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.console.ConsoleUrlProvider;
import jenkins.model.CauseOfInterruption;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.GrantedAuthority;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.jenkinsci.plugins.workflow.support.steps.input.ApproverAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;
import org.jenkinsci.plugins.workflow.support.steps.input.InputSubmittedAction;
import org.jenkinsci.plugins.workflow.support.steps.input.Outcome;
import org.jenkinsci.plugins.workflow.support.steps.input.POSTHyperlinkNote;
import org.jenkinsci.plugins.workflow.support.steps.input.Rejection;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.core.Authentication;

@ExportedBean(defaultVisibility=2)
public class InputStepExecution
extends AbstractStepExecutionImpl
implements ModelObject {
    private static final Logger LOGGER = Logger.getLogger(InputStepExecution.class.getName());
    static final String UNSAFE_PARAMETER_ALLOWED_PROPERTY_NAME = InputStepExecution.class.getName() + ".supportUnsafeParameters";
    private Outcome outcome;
    final InputStep input;
    private static final long serialVersionUID = 1L;

    private static boolean isAllowUnsafeParameters() {
        return SystemProperties.getBoolean((String)UNSAFE_PARAMETER_ALLOWED_PROPERTY_NAME);
    }

    InputStepExecution(InputStep input, StepContext context) {
        super(context);
        this.input = input;
    }

    public boolean start() throws Exception {
        if (this.getHasUnsafeParameters()) {
            if (InputStepExecution.isAllowUnsafeParameters()) {
                this.getListener().getLogger().println("Support for FileParameters in the input step has been enabled via " + UNSAFE_PARAMETER_ALLOWED_PROPERTY_NAME + " which will be removed in a future release." + System.lineSeparator() + "Details on how to migrate your pipeline can be found online: https://jenkins.io/redirect/plugin/pipeline-input-step/file-parameters.");
            } else {
                throw new AbortException("Support for FileParameters in the input step is disabled and will be removed in a future release. " + System.lineSeparator() + "Details on how to migrate your pipeline can be found online: https://jenkins.io/redirect/plugin/pipeline-input-step/file-parameters.");
            }
        }
        if (this.getHasUnsafeId()) {
            this.getListener().getLogger().println("The following 'input' is using an unsafe 'id', please change the 'id' to prevent future breakage");
        }
        Run<?, ?> run = this.getRun();
        TaskListener listener = this.getListener();
        FlowNode node = this.getNode();
        this.getPauseAction().add(this);
        node.addAction((Action)new PauseAction("Input"));
        String baseUrl = "/" + run.getUrl() + this.getPauseAction().getUrlName() + "/";
        if (this.input.getParameters().isEmpty() && this.input.getSubmitterParameter() == null) {
            String thisUrl = baseUrl + Util.rawEncode((String)this.getId()) + "/";
            listener.getLogger().printf("%s%n%s or %s%n", this.input.getMessage(), POSTHyperlinkNote.encodeTo((String)(thisUrl + "proceedEmpty"), (String)this.input.getOk()), POSTHyperlinkNote.encodeTo((String)(thisUrl + "abort"), (String)this.input.getCancel()));
        } else {
            listener.getLogger().println(HyperlinkNote.encodeTo((String)baseUrl, (String)"Input requested"));
        }
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        this.outcome = new Outcome(null, cause);
        Timer.get().submit(new Runnable(){

            @Override
            public void run() {
                try (ACLContext context = ACL.as2((Authentication)ACL.SYSTEM2);){
                    InputStepExecution.this.postSettlement();
                }
                catch (IOException | InterruptedException x) {
                    LOGGER.log(Level.WARNING, "failed to abort " + String.valueOf(InputStepExecution.this.getContext()), x);
                }
            }
        });
        super.stop(cause);
    }

    @Exported
    public String getId() {
        return this.input.getId();
    }

    @Exported
    public InputStep getInput() {
        return this.input;
    }

    public Run<?, ?> getRun() throws IOException, InterruptedException {
        return (Run)this.getContext().get(Run.class);
    }

    private FlowNode getNode() throws InterruptedException, IOException {
        return (FlowNode)this.getContext().get(FlowNode.class);
    }

    private TaskListener getListener() throws IOException, InterruptedException {
        return (TaskListener)this.getContext().get(TaskListener.class);
    }

    @Exported
    public boolean isSettled() {
        return this.outcome != null;
    }

    private InputAction getPauseAction() throws IOException, InterruptedException {
        Run<?, ?> run = this.getRun();
        InputAction a = (InputAction)run.getAction(InputAction.class);
        if (a == null) {
            a = new InputAction();
            run.addAction((Action)a);
        }
        return a;
    }

    @Exported
    public String getDisplayName() {
        String message = this.getInput().getMessage();
        if (message.length() < 32) {
            return message;
        }
        return message.substring(0, 32) + "...";
    }

    @RequirePOST
    public HttpResponse doSubmit(StaplerRequest2 request) throws IOException, jakarta.servlet.ServletException, InterruptedException {
        Run<?, ?> run = this.getRun();
        if (request.getParameter("proceed") != null) {
            this.doProceed(request);
        } else {
            this.doAbort();
        }
        return HttpResponses.redirectTo((String)ConsoleUrlProvider.getRedirectUrl(run));
    }

    @RequirePOST
    public HttpResponse doProceed(StaplerRequest2 request) throws IOException, jakarta.servlet.ServletException, InterruptedException {
        this.preSubmissionCheck();
        Map<String, Object> v = this.parseValue(request);
        return this.proceed(v);
    }

    @Deprecated
    @StaplerNotDispatchable
    public HttpResponse doProceed(StaplerRequest req) throws IOException, ServletException, InterruptedException {
        try {
            return this.doProceed(StaplerRequest.toStaplerRequest2((StaplerRequest)req));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    public HttpResponse proceed(@CheckForNull Map<String, Object> params) throws IOException, InterruptedException {
        User user = User.current();
        String approverId = null;
        if (user != null) {
            approverId = user.getId();
            this.getRun().addAction((Action)new ApproverAction(approverId));
            this.getListener().getLogger().println("Approved by " + ModelHyperlinkNote.encodeTo((User)user));
        }
        this.getNode().addAction((Action)new InputSubmittedAction(approverId, params));
        Object v = params != null && params.size() == 1 ? params.values().iterator().next() : params;
        this.outcome = new Outcome(v, null);
        this.postSettlement();
        this.getContext().onSuccess(v);
        return HttpResponses.ok();
    }

    @Deprecated
    public HttpResponse proceed(Object v) throws IOException, InterruptedException {
        if (v instanceof Map) {
            return this.proceed(new HashMap<String, Object>((Map)v));
        }
        if (v == null) {
            return this.proceed(null);
        }
        return this.proceed(Collections.singletonMap("parameter", v));
    }

    @RequirePOST
    public HttpResponse doProceedEmpty() throws IOException, InterruptedException {
        this.preSubmissionCheck();
        return this.proceed(null);
    }

    @RequirePOST
    public HttpResponse doAbort() throws IOException, InterruptedException {
        this.preAbortCheck();
        FlowInterruptedException e = new FlowInterruptedException(Result.ABORTED, new CauseOfInterruption[]{new Rejection(User.current())});
        this.outcome = new Outcome(null, (Throwable)e);
        this.postSettlement();
        this.getContext().onFailure((Throwable)e);
        return HttpResponses.ok();
    }

    private void preAbortCheck() throws IOException, InterruptedException {
        if (this.isSettled()) {
            throw new Failure("This input has been already given");
        }
        if (!this.canCancel() && !this.canSubmit()) {
            if (this.input.getSubmitter() != null) {
                throw new Failure("You need to be '" + this.input.getSubmitter() + "' (or have Job/Cancel permissions) to cancel this.");
            }
            throw new Failure("You need to have Job/Cancel permissions to cancel this.");
        }
    }

    public void preSubmissionCheck() throws IOException, InterruptedException {
        if (this.isSettled()) {
            throw new Failure("This input has been already given");
        }
        if (!this.canSubmit()) {
            if (this.input.getSubmitter() != null) {
                throw new Failure("You need to be " + this.input.getSubmitter() + " to submit this.");
            }
            throw new Failure("You need to have Job/Build permissions to submit this.");
        }
    }

    private void postSettlement() throws IOException, InterruptedException {
        try {
            this.getPauseAction().remove(this);
            this.getRun().save();
        }
        catch (IOException | InterruptedException | TimeoutException x) {
            try {
                LOGGER.log(Level.WARNING, "failed to remove InputAction from " + String.valueOf(this.getContext()), x);
            }
            catch (Throwable throwable) {
                FlowNode node = this.getNode();
                if (node != null) {
                    try {
                        PauseAction.endCurrentPause((FlowNode)node);
                    }
                    catch (IOException x2) {
                        LOGGER.log(Level.WARNING, "failed to end PauseAction in " + String.valueOf(this.getContext()), x2);
                    }
                } else {
                    LOGGER.log(Level.WARNING, "cannot set pause end time for {0} in {1}", new Object[]{this.getId(), this.getContext()});
                }
                throw throwable;
            }
            FlowNode node = this.getNode();
            if (node != null) {
                try {
                    PauseAction.endCurrentPause((FlowNode)node);
                }
                catch (IOException x3) {
                    LOGGER.log(Level.WARNING, "failed to end PauseAction in " + String.valueOf(this.getContext()), x3);
                }
            } else {
                LOGGER.log(Level.WARNING, "cannot set pause end time for {0} in {1}", new Object[]{this.getId(), this.getContext()});
            }
        }
        FlowNode node = this.getNode();
        if (node != null) {
            try {
                PauseAction.endCurrentPause((FlowNode)node);
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "failed to end PauseAction in " + String.valueOf(this.getContext()), x);
            }
        } else {
            LOGGER.log(Level.WARNING, "cannot set pause end time for {0} in {1}", new Object[]{this.getId(), this.getContext()});
        }
    }

    private boolean canCancel() throws IOException, InterruptedException {
        return !Jenkins.get().isUseSecurity() || this.getRun().getParent().hasPermission(Job.CANCEL);
    }

    private boolean canSubmit() throws IOException, InterruptedException {
        org.acegisecurity.Authentication a = Jenkins.getAuthentication();
        return this.canSettle(a);
    }

    private boolean canSettle(org.acegisecurity.Authentication a) throws IOException, InterruptedException {
        String submitter = this.input.getSubmitter();
        if (submitter == null) {
            return this.getRun().getParent().hasPermission(Job.BUILD);
        }
        if (!Jenkins.get().isUseSecurity() || Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return true;
        }
        HashSet<String> submitters = new HashSet<String>();
        Collections.addAll(submitters, submitter.split(","));
        SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
        if (this.isMemberOf(a.getName(), submitters, securityRealm.getUserIdStrategy())) {
            return true;
        }
        for (GrantedAuthority ga : a.getAuthorities()) {
            if (!this.isMemberOf(ga.getAuthority(), submitters, securityRealm.getGroupIdStrategy())) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberOf(String userId, Set<String> submitters, IdStrategy idStrategy) {
        for (String submitter : submitters) {
            if (!idStrategy.equals(userId, StringUtils.trim((String)submitter))) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> parseValue(StaplerRequest2 request) throws jakarta.servlet.ServletException, IOException, InterruptedException {
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        List<ParameterDefinition> defs = this.input.getParameters();
        HashSet<ParameterValue> vals = new HashSet<ParameterValue>(defs.size());
        Object params = request.getSubmittedForm().get("parameter");
        if (params != null) {
            for (Object o : JSONArray.fromObject((Object)params)) {
                JSONObject jo = (JSONObject)o;
                String name = jo.getString("name");
                ParameterDefinition d = null;
                for (ParameterDefinition def : defs) {
                    if (!def.getName().equals(name)) continue;
                    d = def;
                }
                if (d == null) {
                    throw new IllegalArgumentException("No such parameter definition: " + (String)name);
                }
                ParameterValue v = d.createValue(request, jo);
                if (v == null) continue;
                vals.add(v);
                mapResult.put(name, this.convert(name, v));
            }
        }
        Run<?, ?> run = this.getRun();
        CredentialsParameterBinder binder = CredentialsParameterBinder.getOrCreate(run);
        String userId = Jenkins.getAuthentication2().getName();
        for (ParameterValue val : vals) {
            if (!(val instanceof CredentialsParameterValue)) continue;
            binder.bindCredentialsParameter(userId, (CredentialsParameterValue)val);
        }
        run.replaceAction((Action)binder);
        String valueName = this.input.getSubmitterParameter();
        if (valueName != null && !valueName.isEmpty()) {
            mapResult.put(valueName, userId);
        }
        if (mapResult.isEmpty()) {
            return null;
        }
        return mapResult;
    }

    private Object convert(String name, ParameterValue v) throws IOException, InterruptedException {
        if (v instanceof FileParameterValue) {
            if (InputStepExecution.isAllowUnsafeParameters()) {
                FileParameterValue fv = (FileParameterValue)v;
                FilePath fp = new FilePath(this.getRun().getRootDir()).child(name);
                fp.copyFrom(fv.getFile());
                return fp;
            }
            throw new AbortException("Support for FileParameters in the input step is disabled and will be removed in a future release. " + System.lineSeparator() + "Details on how to migrate your pipeline can be found online: https://jenkins.io/redirect/plugin/pipeline-input-step/file-parameters.");
        }
        return v.getValue();
    }

    @Restricted(value={NoExternalUse.class})
    public boolean getHasUnsafeParameters() {
        return this.input.getParameters().stream().anyMatch(parameter -> parameter.getClass() == FileParameterDefinition.class);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean getHasUnsafeId() {
        return !this.input.getDescriptor().doCheckId((String)this.input.getId()).kind.equals((Object)FormValidation.Kind.OK);
    }
}

