/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.LinkedList;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStep;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepDescriptorImpl;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.shaded.org.yaml.snakeyaml.Yaml;
import org.jenkinsci.plugins.pipeline.utility.steps.shaded.org.yaml.snakeyaml.constructor.SafeConstructor;
import org.jenkinsci.plugins.pipeline.utility.steps.shaded.org.yaml.snakeyaml.reader.UnicodeReader;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class ReadYamlStep
extends AbstractFileOrTextStep {
    @DataBoundConstructor
    public ReadYamlStep() {
    }

    public static class Execution
    extends AbstractFileOrTextStepExecution<Object> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient TaskListener listener;
        @Inject
        private transient ReadYamlStep step;

        @Override
        protected Object doRun() throws Exception {
            String yamlText = "";
            if (!StringUtils.isBlank((String)this.step.getFile())) {
                FilePath path = this.ws.child(this.step.getFile());
                if (!path.exists()) {
                    throw new FileNotFoundException(path.getRemote() + " does not exist.");
                }
                if (path.isDirectory()) {
                    throw new FileNotFoundException(path.getRemote() + " is a directory.");
                }
                UnicodeReader reader = new UnicodeReader(path.read());
                Object object = null;
                try {
                    yamlText = IOUtils.toString((Reader)reader);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (object != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((Reader)reader).close();
                        }
                    }
                }
            }
            if (!StringUtils.isBlank((String)this.step.getText())) {
                yamlText = yamlText + System.getProperty("line.separator") + this.step.getText();
            }
            Iterable<Object> yaml = new Yaml(new SafeConstructor()).loadAll(yamlText);
            LinkedList<Object> result = new LinkedList<Object>();
            for (Object data : yaml) {
                result.add(data);
            }
            try (ObjectOutputStream out = new ObjectOutputStream(new ByteArrayOutputStream());){
                out.writeObject(result);
            }
            if (result.size() == 1) {
                return result.get(0);
            }
            return result;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFileOrTextStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "readYaml";
        }

        public String getDisplayName() {
            return "Read yaml from files in the workspace or text.";
        }
    }
}

