/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.fs.FileWrapper;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TouchStep
extends AbstractStepImpl {
    private final String file;
    private Long timestamp;

    @DataBoundConstructor
    public TouchStep(String file) throws Descriptor.FormException {
        if (StringUtils.isBlank((String)file)) {
            throw new Descriptor.FormException("can't be blank", "file");
        }
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    @DataBoundSetter
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public static class ExecutionImpl
    extends AbstractSynchronousNonBlockingStepExecution<FileWrapper> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient FilePath ws;
        @Inject
        private transient TouchStep step;

        protected FileWrapper run() throws Exception {
            FilePath file = this.ws.child(this.step.getFile());
            long timestamp = this.step.getTimestamp() != null ? this.step.getTimestamp() : System.currentTimeMillis();
            file.getParent().mkdirs();
            file.touch(timestamp);
            return new FileWrapper(file);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(ExecutionImpl.class);
        }

        public String getFunctionName() {
            return "touch";
        }

        public String getDisplayName() {
            return "Create a file (if not already exist) in the workspace, and set the timestamp";
        }

        public FormValidation doCheckFile(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Needs a value");
            }
            return FormValidation.ok();
        }
    }
}

