/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.json;

import hudson.FilePath;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.json.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.json.WriteJSONStep;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;

public class WriteJSONStepExecution
extends AbstractSynchronousNonBlockingStepExecution<Void> {
    private static final long serialVersionUID = 1L;
    @StepContextParameter
    private transient FilePath ws;
    @Inject
    private transient WriteJSONStep step;

    protected Void run() throws Exception {
        if (this.step.getJson() == null) {
            throw new IllegalArgumentException(Messages.WriteJSONStepExecution_missingJSON(this.step.getDescriptor().getFunctionName()));
        }
        if (StringUtils.isBlank((String)this.step.getFile())) {
            throw new IllegalArgumentException(Messages.WriteJSONStepExecution_missingFile(this.step.getDescriptor().getFunctionName()));
        }
        if (StringUtils.isNotBlank((String)this.step.getFile()) && this.ws == null) {
            throw new MissingContextVariableException(FilePath.class);
        }
        FilePath path = this.ws.child(this.step.getFile());
        if (path.isDirectory()) {
            throw new FileNotFoundException(Messages.JSONStepExecution_fileIsDirectory(path.getRemote()));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(path.write());){
            if (this.step.getPretty() > 0) {
                writer.write(this.step.getJson().toString(this.step.getPretty()));
            } else {
                this.step.getJson().write((Writer)writer);
            }
        }
        return null;
    }
}

