// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.utility.steps.toml;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ReadTOMLStepExecution.tooManyArguments}: {@code At most one
     * of file or text must be provided to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code At most one of file or text must be provided to {0}.}
     */
    public static String ReadTOMLStepExecution_tooManyArguments(Object arg0) {
        return holder.format("ReadTOMLStepExecution.tooManyArguments", arg0);
    }

    /**
     * Key {@code ReadTOMLStepExecution.tooManyArguments}: {@code At most one
     * of file or text must be provided to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code At most one of file or text must be provided to {0}.}
     */
    public static Localizable _ReadTOMLStepExecution_tooManyArguments(Object arg0) {
        return new Localizable(holder, "ReadTOMLStepExecution.tooManyArguments", arg0);
    }

    /**
     * Key {@code WriteTOMLStep.DescriptorImpl.displayName}: {@code Write
     * toml to a file in the workspace.}.
     * 
     * @return
     *     {@code Write toml to a file in the workspace.}
     */
    public static String WriteTOMLStep_DescriptorImpl_displayName() {
        return holder.format("WriteTOMLStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code WriteTOMLStep.DescriptorImpl.displayName}: {@code Write
     * toml to a file in the workspace.}.
     * 
     * @return
     *     {@code Write toml to a file in the workspace.}
     */
    public static Localizable _WriteTOMLStep_DescriptorImpl_displayName() {
        return new Localizable(holder, "WriteTOMLStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code WriteTOMLStepExecution_bothReturnTextAndFile}: {@code You
     * cannot provide both returnText and file to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You cannot provide both returnText and file to {0}.}
     */
    public static String WriteTOMLStepExecution_bothReturnTextAndFile(Object arg0) {
        return holder.format("WriteTOMLStepExecution_bothReturnTextAndFile", arg0);
    }

    /**
     * Key {@code WriteTOMLStepExecution_bothReturnTextAndFile}: {@code You
     * cannot provide both returnText and file to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You cannot provide both returnText and file to {0}.}
     */
    public static Localizable _WriteTOMLStepExecution_bothReturnTextAndFile(Object arg0) {
        return new Localizable(holder, "WriteTOMLStepExecution_bothReturnTextAndFile", arg0);
    }

    /**
     * Key {@code WriteTOMLStepExecution_missingTOML}: {@code You have to
     * provide a toml object to save for {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide a toml object to save for {0}.}
     */
    public static String WriteTOMLStepExecution_missingTOML(Object arg0) {
        return holder.format("WriteTOMLStepExecution_missingTOML", arg0);
    }

    /**
     * Key {@code WriteTOMLStepExecution_missingTOML}: {@code You have to
     * provide a toml object to save for {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide a toml object to save for {0}.}
     */
    public static Localizable _WriteTOMLStepExecution_missingTOML(Object arg0) {
        return new Localizable(holder, "WriteTOMLStepExecution_missingTOML", arg0);
    }

    /**
     * Key {@code ReadTOMLStep.DescriptorImpl.displayName}: {@code Read toml
     * from a file in the workspace or text.}.
     * 
     * @return
     *     {@code Read toml from a file in the workspace or text.}
     */
    public static String ReadTOMLStep_DescriptorImpl_displayName() {
        return holder.format("ReadTOMLStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code ReadTOMLStep.DescriptorImpl.displayName}: {@code Read toml
     * from a file in the workspace or text.}.
     * 
     * @return
     *     {@code Read toml from a file in the workspace or text.}
     */
    public static Localizable _ReadTOMLStep_DescriptorImpl_displayName() {
        return new Localizable(holder, "ReadTOMLStep.DescriptorImpl.displayName");
    }

    /**
     * Key {@code TOMLStepExecution.fileIsDirectory}: {@code {0} is a
     * directory.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is a directory.}
     */
    public static String TOMLStepExecution_fileIsDirectory(Object arg0) {
        return holder.format("TOMLStepExecution.fileIsDirectory", arg0);
    }

    /**
     * Key {@code TOMLStepExecution.fileIsDirectory}: {@code {0} is a
     * directory.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is a directory.}
     */
    public static Localizable _TOMLStepExecution_fileIsDirectory(Object arg0) {
        return new Localizable(holder, "TOMLStepExecution.fileIsDirectory", arg0);
    }

    /**
     * Key {@code WriteTOMLStepExecution_missingReturnTextAndFile}: {@code
     * You have to provide either file or returnText to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide either file or returnText to {0}.}
     */
    public static String WriteTOMLStepExecution_missingReturnTextAndFile(Object arg0) {
        return holder.format("WriteTOMLStepExecution_missingReturnTextAndFile", arg0);
    }

    /**
     * Key {@code WriteTOMLStepExecution_missingReturnTextAndFile}: {@code
     * You have to provide either file or returnText to {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have to provide either file or returnText to {0}.}
     */
    public static Localizable _WriteTOMLStepExecution_missingReturnTextAndFile(Object arg0) {
        return new Localizable(holder, "WriteTOMLStepExecution_missingReturnTextAndFile", arg0);
    }

    /**
     * Key {@code TOMLStepExecution.fileNotFound}: {@code {0} does not
     * exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} does not exist.}
     */
    public static String TOMLStepExecution_fileNotFound(Object arg0) {
        return holder.format("TOMLStepExecution.fileNotFound", arg0);
    }

    /**
     * Key {@code TOMLStepExecution.fileNotFound}: {@code {0} does not
     * exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} does not exist.}
     */
    public static Localizable _TOMLStepExecution_fileNotFound(Object arg0) {
        return new Localizable(holder, "TOMLStepExecution.fileNotFound", arg0);
    }

}
