/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.tar;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileCallable;
import org.jenkinsci.plugins.pipeline.utility.steps.DecompressStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.tar.UnTarStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class UnTarStepExecution
extends DecompressStepExecution {
    private static final long serialVersionUID = -7225291403337927553L;
    private transient UnTarStep step;

    protected UnTarStepExecution(@NonNull UnTarStep step, @NonNull StepContext context) {
        super(step, context);
        this.step = step;
    }

    @Override
    protected Object run() throws IOException, InterruptedException {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        if (this.step.isTest()) {
            this.setCallable(new TestTarFileCallable(listener));
        } else {
            this.setCallable(new UnTarFileCallable(listener, this.step.getGlob(), this.step.isQuiet(), this.step.isKeepPermissions()));
        }
        return super.run();
    }

    static class TestTarFileCallable
    extends AbstractFileCallable<Boolean> {
        private TaskListener listener;

        public TestTarFileCallable(TaskListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            PrintStream logger = this.listener.getLogger();
            FileInputStream fileStream = new FileInputStream(f);
            FileChannel fileChannel = fileStream.getChannel();
            logger.printf("Checking %d bytes in %s%n", f.length(), f.getAbsolutePath());
            byte[] signature = new byte[2];
            try {
                fileStream.read(signature);
                fileChannel.position(0L);
            }
            catch (IOException exception) {
                fileStream.close();
                this.listener.error("Error validating tar/tgz file: " + exception.getMessage());
                Boolean bl = false;
                return bl;
            }
            finally {
                logger.flush();
            }
            FileInputStream inputStream = fileStream;
            if (GzipCompressorInputStream.matches((byte[])signature, (int)signature.length)) {
                try {
                    byte[] buffer;
                    inputStream = new GzipCompressorInputStream((InputStream)inputStream);
                    int nRead = -1;
                    while ((nRead = ((InputStream)inputStream).read(buffer = new byte[4096])) >= 0) {
                    }
                    fileChannel.position(0L);
                }
                catch (IOException exception) {
                    ((InputStream)inputStream).close();
                    this.listener.error("Error validating tgz file: " + exception.getMessage());
                    Boolean buffer = false;
                    return buffer;
                }
                finally {
                    logger.flush();
                }
            }
            try (TarArchiveInputStream tarStream = new TarArchiveInputStream((InputStream)inputStream);){
                while (true) {
                    TarArchiveEntry entry;
                    if ((entry = tarStream.getNextTarEntry()) != null) {
                        FilePath ef;
                        if (!entry.isCheckSumOK()) {
                            throw new IOException("Not a tar archive");
                        }
                        FilePath destination = this.getDestination();
                        if (destination == null || this.isDescendantOfDestination(ef = destination.child(entry.getName()))) continue;
                        this.listener.error(ef.getRemote() + " is out of bounds!");
                        Boolean bl = false;
                        return bl;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException exception) {
                this.listener.error("Error validating tar file: " + exception.getMessage());
                Boolean bl = false;
                return bl;
            }
            finally {
                logger.flush();
            }
            return true;
        }
    }

    public static class UnTarFileCallable
    extends AbstractFileCallable<Void> {
        private final TaskListener listener;
        private final String glob;
        private final boolean quiet;
        private final boolean keepPermissions;

        public UnTarFileCallable(TaskListener listener, String glob, boolean quiet, boolean keepPermissions) {
            this.listener = listener;
            this.glob = glob;
            this.quiet = quiet;
            this.keepPermissions = keepPermissions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void invoke(File tarFile, VirtualChannel channel) throws IOException, InterruptedException {
            PrintStream logger = this.listener.getLogger();
            boolean doGlob = !StringUtils.isBlank((String)this.glob);
            FileInputStream fileStream = new FileInputStream(tarFile);
            FileChannel fileChannel = fileStream.getChannel();
            byte[] signature = new byte[2];
            try {
                int read = fileStream.read(signature);
                fileChannel.position(0L);
                if (read <= 0) {
                    logger.println("File is empty.");
                }
            }
            catch (IOException exception) {
                fileStream.close();
                throw new IOException("Error reading tar/tgz file: " + exception.getMessage(), exception);
            }
            finally {
                logger.flush();
            }
            FileInputStream inputStream = fileStream;
            if (GzipCompressorInputStream.matches((byte[])signature, (int)signature.length)) {
                try {
                    inputStream = new GzipCompressorInputStream((InputStream)fileStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.getDestination().mkdirs();
            try (TarArchiveInputStream tarStream = new TarArchiveInputStream((InputStream)inputStream);){
                TarArchiveEntry entry;
                logger.println("Extracting from " + tarFile.getAbsolutePath());
                Integer fileCount = 0;
                while ((entry = tarStream.getNextTarEntry()) != null) {
                    if (doGlob && !this.matches(entry.getName(), this.glob)) continue;
                    FilePath f = this.getDestination().child(entry.getName());
                    if (!this.isDescendantOfDestination(f)) {
                        throw new FileNotFoundException(f.getRemote() + " is out of bounds!");
                    }
                    if (entry.isDirectory()) {
                        f.mkdirs();
                    } else {
                        Integer n = fileCount;
                        fileCount = fileCount + 1;
                        if (!this.quiet) {
                            logger.printf("Extracting: %s -> %s%n", entry.getName(), f.getRemote());
                        }
                        if (entry.isCheckSumOK()) {
                            OutputStream outputStream = f.write();
                            IOUtils.copy((InputStream)tarStream, (OutputStream)outputStream);
                            outputStream.close();
                        } else {
                            throw new IOException("Not a tar archive");
                        }
                    }
                    if (!this.keepPermissions) continue;
                    f.chmod(entry.getMode());
                }
                logger.printf("Extracted: %d files%n", fileCount);
            }
            finally {
                logger.flush();
            }
            return null;
        }

        boolean matches(String path, String glob) {
            String safeGlob = glob.replace('/', File.separatorChar);
            String safePath = path.replace('/', File.separatorChar);
            return SelectorUtils.matchPath((String)safeGlob, (String)safePath);
        }
    }
}

