/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.toml;

import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.toml.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.toml.ReadTOMLStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class ReadTOMLStepExecution
extends AbstractFileOrTextStepExecution<Object> {
    private static final long serialVersionUID = 1L;
    private transient ReadTOMLStep step;

    protected ReadTOMLStepExecution(@NonNull ReadTOMLStep step, @NonNull StepContext context) {
        super(step, context);
        this.step = step;
    }

    @Override
    protected Object doRun() throws Exception {
        String fName = this.step.getDescriptor().getFunctionName();
        if (StringUtils.isNotBlank((String)this.step.getFile()) && StringUtils.isNotBlank((String)this.step.getText())) {
            throw new IllegalArgumentException(Messages.ReadTOMLStepExecution_tooManyArguments(fName));
        }
        Object toml = null;
        TomlMapper mapper = new TomlMapper();
        if (!StringUtils.isBlank((String)this.step.getFile())) {
            FilePath f = this.ws.child(this.step.getFile());
            if (!f.exists()) {
                throw new FileNotFoundException(Messages.TOMLStepExecution_fileNotFound(f.getRemote()));
            }
            if (f.isDirectory()) {
                throw new IllegalArgumentException(Messages.TOMLStepExecution_fileIsDirectory(f.getRemote()));
            }
            try (InputStream is = f.read();){
                toml = mapper.readValue(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), Object.class);
            }
        }
        if (!StringUtils.isBlank((String)this.step.getText())) {
            toml = mapper.readValue(this.step.getText().trim(), Object.class);
        }
        return toml;
    }
}

