/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pubsub;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pubsub.Message;
import org.springframework.security.access.AccessDeniedException;

abstract class AccessControlledMessage<T extends AccessControlledMessage>
extends Message
implements AccessControlled {
    AccessControlledMessage() {
    }

    @NonNull
    protected abstract Permission getRequiredPermission();

    @CheckForNull
    protected abstract AccessControlled getAccessControlled();

    @NonNull
    public ACL getACL() {
        AccessControlled eventItem = this.getAccessControlled();
        if (eventItem != null) {
            return eventItem.getACL();
        }
        return Jenkins.get().getAuthorizationStrategy().getRootACL();
    }

    public void checkPermission(@NonNull Permission permission) throws AccessDeniedException {
        if (this.isUnknownToJenkins()) {
            throw new AccessDeniedException(String.format("Jenkins Object '%s' Unknown.", this.getObjectName()));
        }
        this.getACL().checkPermission(permission);
    }

    public boolean hasPermission(@NonNull Permission permission) {
        if (this.isUnknownToJenkins()) {
            return false;
        }
        return this.getACL().hasPermission(permission);
    }

    private boolean isUnknownToJenkins() {
        return this.getAccessControlled() == null;
    }
}

