/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pubsub;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.jenkinsci.plugins.pubsub.EventProps;
import org.jenkinsci.plugins.pubsub.SimpleMessage;

public abstract class Message<T extends Message>
extends Properties {
    private static final Jenkins jenkins = Jenkins.getInstanceOrNull();
    private static final String instanceIdentity;
    private static final String instanceRootUrl;

    Message() {
        this(true);
    }

    Message(boolean setDefaultProperties) {
        if (!setDefaultProperties) {
            return;
        }
        if (instanceRootUrl != null) {
            this.set(EventProps.Jenkins.jenkins_instance_url, instanceRootUrl);
        }
        this.set(EventProps.Jenkins.jenkins_event_timestamp, Long.toString(System.currentTimeMillis()));
        this.set(EventProps.Jenkins.jenkins_event_uuid, UUID.randomUUID().toString());
    }

    @CheckForNull
    protected String getObjectName() {
        return this.get(EventProps.Jenkins.jenkins_object_name);
    }

    @CheckForNull
    protected String getObjectType() {
        return this.get(EventProps.Jenkins.jenkins_object_type);
    }

    @CheckForNull
    protected String getObjectId() {
        return this.get(EventProps.Jenkins.jenkins_object_id);
    }

    public T set(String name, String value) {
        if (name != null && value != null) {
            this.setProperty(name, value);
        }
        return (T)this;
    }

    public T set(Enum name, String value) {
        return this.set(name.name(), value);
    }

    public String get(String name) {
        return this.getProperty(name);
    }

    public String get(Enum name) {
        return this.getProperty(name.name());
    }

    public String getChannelName() {
        return this.get(EventProps.Jenkins.jenkins_channel);
    }

    public T setChannelName(String name) {
        this.set(EventProps.Jenkins.jenkins_channel, name);
        return (T)this;
    }

    public String getEventName() {
        return this.get(EventProps.Jenkins.jenkins_event);
    }

    public T setEventName(String name) {
        this.set(EventProps.Jenkins.jenkins_event, name);
        return (T)this;
    }

    public T setEventName(Enum name) {
        this.set(EventProps.Jenkins.jenkins_event, name.name());
        return (T)this;
    }

    public String getJenkinsInstanceUrl() {
        return this.get(EventProps.Jenkins.jenkins_instance_url);
    }

    public String getJenkinsInstanceId() {
        return this.get(EventProps.Jenkins.jenkins_instance_id);
    }

    public T setJenkinsInstanceId() {
        if (instanceIdentity != null) {
            this.set(EventProps.Jenkins.jenkins_instance_id, instanceIdentity);
        }
        return (T)this;
    }

    public String getTimestamp() {
        return this.get(EventProps.Jenkins.jenkins_event_timestamp);
    }

    public Long getTimestampMillis() {
        String timestamp = this.getTimestamp();
        if (timestamp == null) {
            return null;
        }
        return Long.valueOf(timestamp);
    }

    public String getEventUUID() {
        return this.get(EventProps.Jenkins.jenkins_event_uuid);
    }

    protected T setItemProps(@NonNull Item item) {
        this.set(EventProps.Jenkins.jenkins_object_name, item.getFullName());
        this.set(EventProps.Jenkins.jenkins_object_url, item.getUrl());
        return (T)this;
    }

    @Override
    public Message clone() {
        SimpleMessage clone = new SimpleMessage();
        clone.putAll((Map<?, ?>)this);
        return clone;
    }

    public boolean containsAll(@NonNull Properties properties) {
        if (!properties.isEmpty()) {
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                String name = entry.getKey().toString();
                String actualValue = this.getProperty(name);
                if (actualValue == null) {
                    return false;
                }
                if (actualValue.equals(entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    @NonNull
    public final String toJSON() {
        StringWriter writer = new StringWriter();
        try {
            this.toJSON(writer);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException while writing to a StringWriter.", e);
        }
        return writer.toString();
    }

    public final void toJSON(@NonNull Writer writer) throws IOException {
        JSONObject json = JSONObject.fromObject((Object)this);
        json.write(writer);
        writer.flush();
    }

    @Override
    public final String toString() {
        return this.toJSON();
    }

    static {
        if (jenkins != null) {
            InstanceIdentity identity = InstanceIdentity.get();
            RSAPublicKey key = identity.getPublic();
            instanceIdentity = new String(Base64.encodeBase64((byte[])key.getEncoded()), StandardCharsets.UTF_8);
            instanceRootUrl = jenkins.getRootUrl();
        } else {
            instanceIdentity = null;
            instanceRootUrl = null;
        }
    }
}

