/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Messages;
import jenkins.scm.impl.trait.Selection;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RegexSCMHeadFilterTrait
extends SCMSourceTrait {
    @NonNull
    private final String regex;
    @CheckForNull
    private transient Pattern pattern;

    @DataBoundConstructor
    public RegexSCMHeadFilterTrait(@NonNull String regex) {
        this.pattern = Pattern.compile(regex);
        this.regex = regex;
    }

    @NonNull
    public String getRegex() {
        return this.regex;
    }

    @NonNull
    private Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regex);
        }
        return this.pattern;
    }

    @Override
    protected void decorateContext(SCMSourceContext<?, ?> context) {
        context.withPrefilter(new SCMHeadPrefilter(){

            @Override
            public boolean isExcluded(@NonNull SCMSource source, @NonNull SCMHead head) {
                return !RegexSCMHeadFilterTrait.this.getPattern().matcher(head.getName()).matches();
            }
        });
    }

    @Symbol(value={"headRegexFilter"})
    @Extension
    @Selection
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.RegexSCMHeadFilterTrait_DisplayName();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRegex(@QueryParameter String value) {
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

