/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.regex.Pattern;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Messages;
import jenkins.scm.impl.trait.Selection;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class WildcardSCMHeadFilterTrait
extends SCMSourceTrait {
    @NonNull
    private final String includes;
    @NonNull
    private final String excludes;

    @DataBoundConstructor
    public WildcardSCMHeadFilterTrait(@CheckForNull String includes, String excludes) {
        this.includes = StringUtils.defaultIfBlank((String)includes, (String)"*");
        this.excludes = StringUtils.defaultIfBlank((String)excludes, (String)"");
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    @Override
    protected void decorateContext(SCMSourceContext<?, ?> context) {
        context.withPrefilter(new SCMHeadPrefilter(){

            @Override
            public boolean isExcluded(@NonNull SCMSource request, @NonNull SCMHead head) {
                return !Pattern.matches(WildcardSCMHeadFilterTrait.this.getPattern(WildcardSCMHeadFilterTrait.this.getIncludes()), head.getName()) || Pattern.matches(WildcardSCMHeadFilterTrait.this.getPattern(WildcardSCMHeadFilterTrait.this.getExcludes()), head.getName());
            }
        });
    }

    private String getPattern(String branches) {
        StringBuilder quotedBranches = new StringBuilder();
        for (String wildcard : branches.split(" ")) {
            StringBuilder quotedBranch = new StringBuilder();
            for (String branch : wildcard.split("(?=[*])|(?<=[*])")) {
                if (branch.equals("*")) {
                    quotedBranch.append(".*");
                    continue;
                }
                if (branch.isEmpty()) continue;
                quotedBranch.append(Pattern.quote(branch));
            }
            if (quotedBranches.length() > 0) {
                quotedBranches.append("|");
            }
            quotedBranches.append((CharSequence)quotedBranch);
        }
        return quotedBranches.toString();
    }

    @Symbol(value={"headWildcardFilter"})
    @Extension
    @Selection
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.WildcardSCMHeadFilterTrait_DisplayName();
        }
    }
}

