// CHECKSTYLE:OFF

package jenkins.scm.api;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code SCMNavigator.Description}: {@code A collection of SCM
     * repositories}.
     * 
     * @return
     *     {@code A collection of SCM repositories}
     */
    public static String SCMNavigator_Description() {
        return holder.format("SCMNavigator.Description");
    }

    /**
     * Key {@code SCMNavigator.Description}: {@code A collection of SCM
     * repositories}.
     * 
     * @return
     *     {@code A collection of SCM repositories}
     */
    public static Localizable _SCMNavigator_Description() {
        return new Localizable(holder, "SCMNavigator.Description");
    }

    /**
     * Key {@code SCMCategory.Join}: {@code {0} / {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} / {1}}
     */
    public static String SCMCategory_Join(Object arg0, Object arg1) {
        return holder.format("SCMCategory.Join", arg0, arg1);
    }

    /**
     * Key {@code SCMCategory.Join}: {@code {0} / {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} / {1}}
     */
    public static Localizable _SCMCategory_Join(Object arg0, Object arg1) {
        return new Localizable(holder, "SCMCategory.Join", arg0, arg1);
    }

    /**
     * Key {@code SCMSourceCategory.DisplayName}: {@code Repositories}.
     * 
     * @return
     *     {@code Repositories}
     */
    public static String SCMSourceCategory_DisplayName() {
        return holder.format("SCMSourceCategory.DisplayName");
    }

    /**
     * Key {@code SCMSourceCategory.DisplayName}: {@code Repositories}.
     * 
     * @return
     *     {@code Repositories}
     */
    public static Localizable _SCMSourceCategory_DisplayName() {
        return new Localizable(holder, "SCMSourceCategory.DisplayName");
    }

    /**
     * Key {@code SCMHeadCategory.DisplayName}: {@code Branches}.
     * 
     * @return
     *     {@code Branches}
     */
    public static String SCMHeadCategory_DisplayName() {
        return holder.format("SCMHeadCategory.DisplayName");
    }

    /**
     * Key {@code SCMHeadCategory.DisplayName}: {@code Branches}.
     * 
     * @return
     *     {@code Branches}
     */
    public static Localizable _SCMHeadCategory_DisplayName() {
        return new Localizable(holder, "SCMHeadCategory.DisplayName");
    }

}
