/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.simpletheme;

import hudson.Extension;
import hudson.model.Descriptor;
import java.text.MessageFormat;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.simpletheme.Messages;
import org.jenkinsci.plugins.simpletheme.ThemeElement;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CssTextThemeElement
extends ThemeElement {
    private static final String CSS_HTML = "<style type=\"text/css\">\n{0}\n</style>";
    private String text;

    @DataBoundConstructor
    public CssTextThemeElement(String text) {
        this.setText(text);
    }

    public String getText() {
        return this.text;
    }

    @DataBoundSetter
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void collectHeaderFragment(Set<String> fragments, boolean injectCss) {
        fragments.add(MessageFormat.format(CSS_HTML, this.getText()));
    }

    @Extension
    @Symbol(value={"cssText"})
    public static final class DescriptorImpl
    extends Descriptor<ThemeElement> {
        public String getDisplayName() {
            return Messages.cssText();
        }
    }
}

