/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs.describable;

import com.google.common.primitives.Primitives;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.GString;
import hudson.ExtensionList;
import hudson.Main;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.ObjectUtils;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.jenkinsci.plugins.structs.describable.CustomDescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;
import org.jenkinsci.plugins.structs.describable.Setter;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jvnet.tiger_types.Types;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.lang.Klass;

@SuppressFBWarnings(value={"SE_BAD_FIELD"})
public final class DescribableModel<T>
implements Serializable {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean STRICT_PARAMETER_CHECKING = Main.isUnitTest;
    private final Class<T> type;
    private Map<String, DescribableParameter> parameters = new LinkedHashMap<String, DescribableParameter>(4);
    private Map<String, DescribableParameter> parametersView;
    private final Constructor<T> constructor;
    private final String[] constructorParamNames;
    static ConcurrentHashMap<String, DescribableModel> modelCache = new ConcurrentHashMap();
    public static final String CLAZZ = "$class";
    private static final Logger LOGGER = Logger.getLogger(DescribableModel.class.getName());
    private static final long serialVersionUID = 1L;
    private static final Map<Class, Object> defaultPrimitiveValue = new HashMap<Class, Object>();

    public static <T> DescribableModel<T> of(Class<T> clazz) {
        DescribableModel<T> mod = modelCache.get(clazz.getName());
        if (mod != null && mod.type == clazz) {
            return mod;
        }
        mod = new DescribableModel<T>(clazz);
        modelCache.put(clazz.getName(), mod);
        return mod;
    }

    public DescribableModel(Class<T> clazz) {
        this.type = clazz;
        DescribableModel mod = modelCache.get(clazz.getName());
        if (mod != null && mod.type == clazz) {
            this.constructor = mod.constructor;
            this.parameters = mod.parameters;
            this.constructorParamNames = mod.constructorParamNames;
            this.parametersView = mod.parametersView;
            return;
        }
        this.constructorParamNames = this.type == ParametersDefinitionProperty.class ? new String[]{"parameterDefinitions"} : new ClassDescriptor(this.type, new Class[0]).loadConstructorParamNames();
        this.constructor = this.findConstructor(this.constructorParamNames.length);
        Type[] types = this.constructor.getGenericParameterTypes();
        for (int i = 0; i < this.constructorParamNames.length; ++i) {
            this.addParameter(this.parameters, types[i], this.constructorParamNames[i], null);
        }
        TreeMap<String, DescribableParameter> rest = new TreeMap<String, DescribableParameter>();
        for (Class<T> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(DataBoundSetter.class)) continue;
                this.addParameter(rest, field.getGenericType(), field.getName(), Setter.create(field));
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                if (!accessibleObject.isAnnotationPresent(DataBoundSetter.class)) continue;
                Type[] parameterTypes = ((Method)accessibleObject).getGenericParameterTypes();
                if (!((Method)accessibleObject).getName().startsWith("set") || parameterTypes.length != 1) {
                    throw new IllegalStateException(accessibleObject + " cannot be a @DataBoundSetter");
                }
                this.addParameter(rest, ((Method)accessibleObject).getGenericParameterTypes()[0], Introspector.decapitalize(((Method)accessibleObject).getName().substring(3)), Setter.create((Method)accessibleObject));
            }
        }
        this.parameters.putAll(rest);
        this.parametersView = Collections.unmodifiableMap(this.parameters);
        modelCache.putIfAbsent(clazz.getName(), this);
    }

    private void addParameter(Map<String, DescribableParameter> props, Type type, String name, Setter setter) {
        props.put(name, new DescribableParameter(this, type, name, setter));
    }

    public Class<T> getType() {
        return this.type;
    }

    public Collection<DescribableParameter> getParameters() {
        return this.parametersView.values();
    }

    public DescribableParameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public boolean hasSingleRequiredParameter() {
        return this.getSoleRequiredParameter() != null;
    }

    @CheckForNull
    public DescribableParameter getSoleRequiredParameter() {
        DescribableParameter rp = null;
        for (DescribableParameter p : this.getParameters()) {
            if (!p.isRequired()) continue;
            if (rp != null) {
                return null;
            }
            rp = p;
        }
        return rp;
    }

    @CheckForNull
    public DescribableParameter getFirstRequiredParameter() {
        for (DescribableParameter p : this.getParameters()) {
            if (!p.isRequired()) continue;
            return p;
        }
        return null;
    }

    public String getDisplayName() {
        for (Descriptor d : ExtensionList.lookup(Descriptor.class)) {
            if (d.clazz != this.type) continue;
            return d.getDisplayName();
        }
        return this.type.getSimpleName();
    }

    @Deprecated
    public T instantiate(Map<String, ?> arguments) throws IllegalArgumentException {
        return this.instantiate(arguments, (TaskListener)new LogTaskListener(LOGGER, Level.FINE));
    }

    public T instantiate(Map<String, ?> arguments, @CheckForNull TaskListener listener) throws IllegalArgumentException {
        CustomDescribableModel cdm;
        if (listener == null) {
            listener = new LogTaskListener(LOGGER, Level.WARNING);
        }
        if ((cdm = CustomDescribableModel.of(this.type)) != null) {
            Map<String, Object> input = DescribableModel.deeplyImmutable(arguments);
            arguments = cdm.customInstantiate(input);
            LOGGER.log(Level.FINE, "{0} translated {1} to {2}", new Object[]{cdm.getClass(), input, arguments});
        }
        if (arguments.containsKey("<anonymous>")) {
            if (arguments.size() != 1) {
                throw new IllegalArgumentException("All arguments have to be named but it has <anonymous>");
            }
            DescribableParameter rp = this.getSoleRequiredParameter();
            if (rp == null) {
                throw new IllegalArgumentException("Arguments to " + this.type + " have to be explicitly named");
            }
            arguments = Collections.singletonMap(rp.getName(), arguments.get("<anonymous>"));
        }
        TreeSet<String> erroneous = new TreeSet<String>(arguments.keySet());
        erroneous.removeAll(this.parameters.keySet());
        if (erroneous.size() > 0) {
            String msg = "WARNING: Unknown parameter(s) found for class type '" + this.type.getName() + "': " + String.join((CharSequence)",", erroneous);
            if (STRICT_PARAMETER_CHECKING) {
                throw new IllegalArgumentException(msg);
            }
            listener.getLogger().println(msg);
        }
        try {
            Object[] args = this.buildArguments(arguments, this.constructor.getGenericParameterTypes(), this.constructorParamNames, true, listener);
            T o = this.constructor.newInstance(args);
            this.injectSetters(o, arguments, listener);
            return o;
        }
        catch (Exception x) {
            throw new IllegalArgumentException("Could not instantiate " + arguments + " for " + this.type.getName() + ": " + x, x);
        }
    }

    private static Map<String, Object> deeplyImmutable(Map<String, ?> m) {
        HashMap r = new HashMap();
        for (Map.Entry<String, ?> e : m.entrySet()) {
            Object v = e.getValue();
            if (v instanceof UninstantiatedDescribable) {
                v = DescribableModel.deeplyImmutable((UninstantiatedDescribable)v);
            } else if (v instanceof Map) {
                v = DescribableModel.deeplyImmutable((Map)v);
            }
            r.put(e.getKey(), v);
        }
        return Collections.unmodifiableMap(r);
    }

    private static UninstantiatedDescribable deeplyImmutable(UninstantiatedDescribable ud) {
        return ud.withArguments(DescribableModel.deeplyImmutable(ud.getArguments()));
    }

    private Constructor<T> findConstructor(int length) {
        Constructor<?>[] ctrs;
        try {
            if (this.type == ParametersDefinitionProperty.class && length == 1) {
                return ParametersDefinitionProperty.class.getConstructor(List.class);
            }
        }
        catch (NoSuchMethodException x) {
            throw new AssertionError((Object)x);
        }
        for (Constructor<?> c : ctrs = this.type.getConstructors()) {
            if (c.getAnnotation(DataBoundConstructor.class) == null) continue;
            if (c.getParameterTypes().length != length) {
                throw new IllegalArgumentException(c + " has @DataBoundConstructor but it doesn't match with your .stapler file. Try clean rebuild");
            }
            return c;
        }
        for (Constructor<?> c : ctrs) {
            if (c.getParameterTypes().length != length) continue;
            return c;
        }
        throw new IllegalArgumentException(this.type + " does not have a constructor with " + length + " arguments");
    }

    private Object[] buildArguments(Map<String, ?> bag, Type[] types, String[] names, boolean callEvenIfNoArgs, TaskListener listener) throws Exception {
        assert (names.length == types.length);
        Object[] args = new Object[names.length];
        boolean hasArg = callEvenIfNoArgs;
        for (int i = 0; i < args.length; ++i) {
            String name = names[i];
            hasArg |= bag.containsKey(name);
            Object a = bag.get(name);
            Type type = types[i];
            if (a != null) {
                args[i] = this.coerce(this.type.getName() + "." + name, type, a, listener);
                continue;
            }
            if (!(type instanceof Class) || !((Class)type).isPrimitive()) continue;
            args[i] = DescribableModel.getVmDefaultValueForPrimitiveType((Class)type);
            if (args[i] != null || !callEvenIfNoArgs) continue;
            throw new UnsupportedOperationException("not yet handling @DataBoundConstructor default value of " + type + "; pass an explicit value for " + name);
        }
        return hasArg ? args : null;
    }

    private void injectSetters(Object o, Map<String, ?> arguments, TaskListener listener) throws Exception {
        for (DescribableParameter p : this.parameters.values()) {
            if (p.setter == null || !arguments.containsKey(p.getName())) continue;
            Object v = arguments.get(p.getName());
            p.setter.set(o, this.coerce(p.setter.getDisplayName(), p.getRawType(), v, listener));
        }
    }

    private Object coerce(String context, Type type, Object o, TaskListener listener) throws Exception {
        Class erased = Types.erasure((Type)type);
        if (type instanceof Class) {
            o = ReflectionCache.getCachedClass((Class)erased).coerceArgument(o);
        }
        if (o instanceof GString) {
            o = o.toString();
        }
        if (o instanceof List && Collection.class.isAssignableFrom(erased)) {
            return this.coerceList(context, Types.getTypeArgument((Type)Types.getBaseClass((Type)type, Collection.class), (int)0, Object.class), (List)o, listener);
        }
        if (Primitives.wrap((Class)erased).isInstance(o)) {
            return o;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof UninstantiatedDescribable) {
            return ((UninstantiatedDescribable)o).instantiate(erased, listener);
        }
        if (o instanceof Map) {
            HashMap m = new HashMap();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                m.put((String)entry.getKey(), entry.getValue());
            }
            Class<?> clazz = DescribableModel.resolveClass(erased, (String)m.remove(CLAZZ), null);
            return new DescribableModel(clazz).instantiate(m, listener);
        }
        if (o instanceof String && erased.isEnum()) {
            return Enum.valueOf(erased.asSubclass(Enum.class), (String)o);
        }
        if (o instanceof String && erased == URL.class) {
            return new URL((String)o);
        }
        if (o instanceof String && erased == Result.class) {
            return Result.fromString((String)((String)o));
        }
        if (o instanceof String && (erased == Character.TYPE || erased == Character.class) && ((String)o).length() == 1) {
            return Character.valueOf(((String)o).charAt(0));
        }
        if (o instanceof String && ClassUtils.isAssignable((Class)ClassUtils.primitiveToWrapper((Class)erased), Number.class)) {
            return this.coerceStringToNumber(context, ClassUtils.primitiveToWrapper((Class)erased), (String)o);
        }
        if (o instanceof String && (erased == Boolean.TYPE || erased == Boolean.class)) {
            return Boolean.valueOf((String)o);
        }
        if (o instanceof List && erased.isArray()) {
            Class<?> componentType = erased.getComponentType();
            List<Object> list = this.coerceList(context, componentType, (List)o, listener);
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        throw new ClassCastException(context + " expects " + type + " but received " + o.getClass());
    }

    private Object coerceStringToNumber(@Nonnull String context, @Nonnull Class numberClass, @Nonnull String o) throws ClassCastException {
        try {
            if (numberClass.equals(Integer.class)) {
                return Integer.valueOf(o);
            }
            if (numberClass.equals(Float.class)) {
                return Float.valueOf(o);
            }
            if (numberClass.equals(Double.class)) {
                return Double.valueOf(o);
            }
            if (numberClass.equals(Long.class)) {
                return Long.valueOf(o);
            }
            if (numberClass.equals(Byte.class)) {
                return Byte.valueOf(o);
            }
            if (numberClass.equals(Short.class)) {
                return Short.valueOf(o);
            }
            return o;
        }
        catch (NumberFormatException nfe) {
            throw new ClassCastException(context + " expects " + numberClass + " but was unable to coerce the received value \"" + o + "\" to that type");
        }
    }

    static Class<?> resolveClass(Class<?> base, @Nullable String name, @Nullable String symbol) throws ClassNotFoundException {
        if (name != null) {
            if (name.contains(".")) {
                Jenkins j = Jenkins.getInstanceOrNull();
                ClassLoader loader = j != null ? j.getPluginManager().uberClassLoader : Thread.currentThread().getContextClassLoader();
                return Class.forName(name, true, loader);
            }
            Class<?> clazz = null;
            for (Class<?> c : DescribableModel.findSubtypes(base)) {
                if (!c.getSimpleName().equals(name)) continue;
                if (clazz != null) {
                    throw new UnsupportedOperationException(name + " as a " + base + " could mean either " + clazz.getName() + " or " + c.getName());
                }
                clazz = c;
            }
            if (clazz == null) {
                throw new UnsupportedOperationException("no known implementation of " + base + " is named " + name);
            }
            return clazz;
        }
        if (symbol != null) {
            Class<?> c;
            Descriptor<?> d = SymbolLookup.get().findDescriptor(base, symbol);
            if (d != null) {
                return d.clazz;
            }
            if (base == ParameterValue.class && (d = SymbolLookup.get().findDescriptor(ParameterDefinition.class, symbol)) != null && (c = DescribableModel.parameterValueClass(d.clazz)) != null) {
                return c;
            }
            throw new UnsupportedOperationException("no known implementation of " + base + " is using symbol \u2018" + symbol + "\u2019");
        }
        if (Modifier.isAbstract(base.getModifiers())) {
            throw new UnsupportedOperationException("must specify $class with an implementation of " + base);
        }
        return base;
    }

    private List<Object> coerceList(String context, Type type, List<?> list, TaskListener listener) throws Exception {
        ArrayList<Object> r = new ArrayList<Object>();
        for (Object elt : list) {
            r.add(this.coerce(context, type, elt, listener));
        }
        return r;
    }

    @CheckForNull
    private static Class<?> parameterValueClass(@Nonnull Class<?> parameterDefinitionClass) {
        String name = parameterDefinitionClass.getName();
        if (name.endsWith("Definition")) {
            try {
                Class<?> parameterValueClass = parameterDefinitionClass.getClassLoader().loadClass(name.replaceFirst("Definition$", "Value"));
                if (ParameterValue.class.isAssignableFrom(parameterValueClass)) {
                    return parameterValueClass;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    static Set<Class<?>> findSubtypes(Class<?> supertype) {
        HashSet clazzes = new HashSet();
        for (Descriptor descriptor : ExtensionList.lookup(Descriptor.class)) {
            if (!supertype.isAssignableFrom(descriptor.clazz)) continue;
            clazzes.add(descriptor.clazz);
        }
        if (supertype == ParameterValue.class) {
            for (Class<ParameterDefinition> clazz : DescribableModel.findSubtypes(ParameterDefinition.class)) {
                Class<ParameterDefinition> c = DescribableModel.parameterValueClass(clazz);
                if (c == null) continue;
                clazzes.add(c);
            }
        }
        return clazzes;
    }

    public Map<String, Object> uninstantiate(T o) throws UnsupportedOperationException {
        return this.uninstantiate2(o).toMap();
    }

    public UninstantiatedDescribable uninstantiate2(T o) throws UnsupportedOperationException {
        Object v;
        if (o == null) {
            throw new IllegalArgumentException("Expected " + this.type + " but got null");
        }
        if (!this.type.isInstance(o)) {
            throw new IllegalArgumentException("Expected " + this.type + " but got an instance of " + o.getClass());
        }
        TreeMap<String, Object> r = new TreeMap<String, Object>();
        TreeMap<String, Object> constructorOnlyDataBoundProps = new TreeMap<String, Object>();
        TreeMap<String, Object> nonDeprecatedDataBoundProps = new TreeMap<String, Object>();
        for (DescribableParameter p : this.parameters.values()) {
            Object v2 = p.inspect(o);
            if (p.isRequired() && v2 == null) continue;
            r.put(p.getName(), v2);
            if (p.isRequired()) {
                constructorOnlyDataBoundProps.put(p.getName(), v2);
            }
            if (p.isDeprecated()) continue;
            nonDeprecatedDataBoundProps.put(p.getName(), v2);
        }
        Object control = null;
        try {
            control = this.instantiate(constructorOnlyDataBoundProps, null);
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "Cannot create control version of " + this.type + " using " + constructorOnlyDataBoundProps, x);
        }
        if (control != null) {
            for (DescribableParameter p : this.parameters.values()) {
                if (p.isRequired() || !ObjectUtils.equals((Object)(v = p.inspect(control)), r.get(p.getName()))) continue;
                r.remove(p.getName());
                nonDeprecatedDataBoundProps.remove(p.getName());
            }
        }
        if (!nonDeprecatedDataBoundProps.keySet().equals(r.keySet())) {
            control = null;
            try {
                control = this.instantiate(nonDeprecatedDataBoundProps, null);
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "Cannot create control version of " + this.type + " using " + nonDeprecatedDataBoundProps, x);
            }
            if (control != null) {
                for (DescribableParameter p : this.parameters.values()) {
                    if (!p.isDeprecated() || !ObjectUtils.equals((Object)(v = p.inspect(control)), r.get(p.getName()))) continue;
                    r.remove(p.getName());
                }
            }
        }
        UninstantiatedDescribable ud = new UninstantiatedDescribable(DescribableModel.symbolOf(o), null, r);
        ud.setModel(this);
        CustomDescribableModel cdm = CustomDescribableModel.of(this.type);
        if (cdm != null) {
            UninstantiatedDescribable input = DescribableModel.deeplyImmutable(ud);
            ud = cdm.customUninstantiate(input);
            LOGGER.log(Level.FINE, "{0} translated {1} to {2}", new Object[]{cdm.getClass(), input, ud});
        }
        return ud;
    }

    static String symbolOf(Object o) {
        Set<String> symbols = SymbolLookup.getSymbolValue(o);
        return symbols.isEmpty() ? null : symbols.iterator().next();
    }

    public static Map<String, Object> uninstantiate_(Object o) {
        return DescribableModel.uninstantiate__(o, o.getClass());
    }

    private static <T> Map<String, Object> uninstantiate__(Object o, Class<T> clazz) {
        return DescribableModel.of(clazz).uninstantiate(clazz.cast(o));
    }

    public static UninstantiatedDescribable uninstantiate2_(Object o) {
        return new DescribableModel(o.getClass()).uninstantiate2(o);
    }

    public boolean isDeprecated() {
        return this.type.getAnnotation(Deprecated.class) != null;
    }

    @CheckForNull
    public String getHelp() throws IOException {
        return this.getHelp("help.html");
    }

    @CheckForNull
    String getHelp(String name) throws IOException {
        for (Klass c = Klass.java(this.type); c != null; c = c.getSuperClass()) {
            URL u = c.getResource(name);
            if (u == null) continue;
            return IOUtils.toString((URL)u, (String)"UTF-8");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toString(StringBuilder b, Stack<Class<?>> modelTypes) {
        b.append(this.type.getSimpleName());
        if (modelTypes.contains(this.type)) {
            b.append('\u2026');
        } else {
            modelTypes.push(this.type);
            try {
                b.append('(');
                boolean first = true;
                for (DescribableParameter dp : this.getParameters()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    dp.toString(b, modelTypes);
                }
                b.append(')');
            }
            finally {
                modelTypes.pop();
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b, new Stack());
        return b.toString();
    }

    private Object writeReplace() {
        return new SerializedForm(this.type);
    }

    private static Object getVmDefaultValueForPrimitiveType(Class<?> type) {
        return defaultPrimitiveValue.get(type);
    }

    static {
        defaultPrimitiveValue.put(Boolean.TYPE, false);
        defaultPrimitiveValue.put(Byte.TYPE, (byte)0);
        defaultPrimitiveValue.put(Short.TYPE, (short)0);
        defaultPrimitiveValue.put(Integer.TYPE, 0);
        defaultPrimitiveValue.put(Long.TYPE, 0L);
        defaultPrimitiveValue.put(Float.TYPE, Float.valueOf(0.0f));
        defaultPrimitiveValue.put(Double.TYPE, 0.0);
    }

    private static class SerializedForm
    implements Serializable {
        private final Class type;
        private static final long serialVersionUID = 1L;

        public SerializedForm(Class type) {
            this.type = type;
        }

        private Object readResolve() {
            return DescribableModel.of(this.type);
        }
    }
}

