/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import hudson.console.LineTransformationOutputStream;
import hudson.plugins.timestamper.TimestampNote;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class TimestampNotesOutputStream
extends LineTransformationOutputStream {
    private final OutputStream delegate;
    private final long buildStartTime;
    private long lastTime;
    private byte[] lastNote;

    public TimestampNotesOutputStream(OutputStream delegate, long buildStartTime) {
        this.delegate = Objects.requireNonNull(delegate);
        this.buildStartTime = buildStartTime;
        this.lastTime = 0L;
    }

    protected void eol(byte[] b, int len) throws IOException {
        long now = System.currentTimeMillis();
        if (now != this.lastTime) {
            this.lastNote = new TimestampNote(now - this.buildStartTime, now).encode().getBytes(StandardCharsets.UTF_8);
            this.lastTime = now;
        }
        this.delegate.write(this.lastNote);
        this.delegate.write(b, 0, len);
    }

    public void close() throws IOException {
        super.close();
        this.delegate.close();
    }
}

