/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.annotator;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleAnnotatorFactory;
import hudson.model.InvisibleAction;
import hudson.model.RootAction;
import hudson.model.Run;
import hudson.plugins.timestamper.TimestampNote;
import hudson.plugins.timestamper.annotator.ConsoleLogParser;
import hudson.plugins.timestamper.annotator.TimestampAnnotator;
import hudson.plugins.timestamper.format.TimestampFormat;
import hudson.plugins.timestamper.format.TimestampFormatProvider;
import jenkins.YesNoMaybe;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest2;

@Extension(dynamicLoadable=YesNoMaybe.YES)
public final class TimestampAnnotatorFactory3
extends ConsoleAnnotatorFactory<Run<?, ?>> {
    public ConsoleAnnotator<Run<?, ?>> newInstance(Run<?, ?> build) {
        if (TimestampNote.useTimestampNotes(build.getClass())) {
            return null;
        }
        StaplerRequest2 request = Stapler.getCurrentRequest2();
        if (request == null) {
            return null;
        }
        long offset = TimestampAnnotatorFactory3.getOffset(request);
        ConsoleLogParser logParser = new ConsoleLogParser(offset);
        return new TimestampAnnotator(logParser);
    }

    private static long getOffset(StaplerRequest2 request) {
        String path = request.getPathInfo();
        if (path == null) {
            path = request.getServletPath();
        }
        if (path.endsWith("/consoleFull")) {
            return 0L;
        }
        if (path.endsWith("/console")) {
            String threshold = System.getProperty("hudson.consoleTailKB", "150");
            return -(Long.parseLong(threshold) * 1024L);
        }
        String startParameter = request.getParameter("start");
        return startParameter == null ? 0L : Long.parseLong(startParameter);
    }

    public String getPlainTextUrl() {
        TimestampFormat format = TimestampFormatProvider.get();
        return format.getPlainTextUrl();
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class RootActionImpl
    extends InvisibleAction
    implements RootAction,
    StaplerProxy {
        public String getUrlName() {
            return "hudson.plugins.timestamper.annotator.TimestampAnnotatorFactory3";
        }

        public Object getTarget() {
            return ExtensionList.lookupSingleton(TimestampAnnotatorFactory3.class);
        }
    }
}

