/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro;

import com.google.common.collect.ListMultimap;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public abstract class DataBoundTokenMacro
extends TokenMacro {
    private Map<String, Setter> setters;
    @Parameter
    public boolean escapeHtml = false;

    public DataBoundTokenMacro() {
        this.buildMap();
    }

    private void buildMap() {
        Parameter p;
        if (this.setters != null) {
            return;
        }
        this.setters = new ConcurrentHashMap<String, Setter>();
        for (final Field field : this.getClass().getFields()) {
            p = field.getAnnotation(Parameter.class);
            if (p == null) continue;
            String name = field.getName();
            if (StringUtils.isNotEmpty((String)p.alias())) {
                name = p.alias();
            }
            this.setters.put(name, new Setter(){

                @Override
                public Class<?> getType() {
                    return field.getType();
                }

                @Override
                public void set(Object target, Object value) {
                    try {
                        field.set(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw (IllegalAccessError)new IllegalAccessError(e.getMessage()).initCause(e);
                    }
                }

                @Override
                public boolean required() {
                    return p.required();
                }
            });
        }
        for (AccessibleObject accessibleObject : this.getClass().getMethods()) {
            p = ((Method)accessibleObject).getAnnotation(Parameter.class);
            if (p == null) continue;
            final Class[] pt = ((Method)accessibleObject).getParameterTypes();
            if (pt.length != 1) {
                throw new IllegalArgumentException("Expecting one-arg method for @Parameter but found " + String.valueOf(accessibleObject) + " instead");
            }
            String name = ((Method)accessibleObject).getName();
            if (name.startsWith("set")) {
                name = Introspector.decapitalize(name.substring(3));
            }
            if (StringUtils.isNotEmpty((String)p.alias())) {
                name = p.alias();
            }
            this.setters.put(name, new Setter(){
                final /* synthetic */ Method val$m;
                final /* synthetic */ Parameter val$p;
                {
                    this.val$m = method;
                    this.val$p = parameter;
                }

                @Override
                public Class<?> getType() {
                    return pt[0];
                }

                @Override
                public void set(Object target, Object value) {
                    try {
                        this.val$m.invoke(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw (IllegalAccessError)new IllegalAccessError(e.getMessage()).initCause(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new Error(e);
                    }
                }

                @Override
                public boolean required() {
                    return this.val$p.required();
                }
            });
        }
    }

    private DataBoundTokenMacro prepare(String macroName, Map<String, String> arguments, ListMultimap<String, String> argumentMultimap) throws MacroEvaluationException {
        DataBoundTokenMacro copy;
        try {
            copy = (DataBoundTokenMacro)this.getClass().newInstance();
            for (Map.Entry entry : argumentMultimap.entries()) {
                Setter s = this.setters.get(entry.getKey());
                if (s == null) {
                    throw new MacroEvaluationException(MessageFormat.format("Undefined parameter {0} in token {1}", entry.getKey(), macroName));
                }
                Object v = s.getType() == Boolean.TYPE && entry.getValue() == null ? Boolean.valueOf(true) : ConvertUtils.convert((String)((String)entry.getValue()), s.getType());
                s.set(copy, v);
            }
            for (Map.Entry entry : this.setters.entrySet()) {
                if (arguments.containsKey(entry.getKey()) || !((Setter)entry.getValue()).required()) continue;
                throw new MacroEvaluationException(MessageFormat.format("Parameter {0} in token {1} is required but was not specfified", entry.getKey(), macroName));
            }
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        return copy;
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName, Map<String, String> arguments, ListMultimap<String, String> argumentMultimap) throws MacroEvaluationException, IOException, InterruptedException {
        DataBoundTokenMacro copy = this.prepare(macroName, arguments, argumentMultimap);
        String res = copy.evaluate(build, listener, macroName);
        if (copy.escapeHtml && !copy.handlesHtmlEscapeInternally()) {
            res = StringEscapeUtils.escapeHtml((String)res);
        }
        return res;
    }

    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName, Map<String, String> arguments, ListMultimap<String, String> argumentMultimap) throws MacroEvaluationException, IOException, InterruptedException {
        DataBoundTokenMacro copy = this.prepare(macroName, arguments, argumentMultimap);
        String res = copy.evaluate(run, workspace, listener, macroName);
        if (copy.escapeHtml && !copy.handlesHtmlEscapeInternally()) {
            res = StringEscapeUtils.escapeHtml((String)res);
        }
        return res;
    }

    public boolean handlesHtmlEscapeInternally() {
        return false;
    }

    public abstract String evaluate(AbstractBuild<?, ?> var1, TaskListener var2, String var3) throws MacroEvaluationException, IOException, InterruptedException;

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return macroName + " is not supported in this context";
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Parameter {
        public boolean required() default false;

        public String alias() default "";
    }

    private static interface Setter {
        public Class<?> getType();

        public void set(Object var1, Object var2);

        public boolean required();
    }
}

