/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.WorkspaceDependentMacro;

@Extension
public class WorkspaceFileMacro
extends WorkspaceDependentMacro {
    @DataBoundTokenMacro.Parameter(required=true)
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Retain API compatibility.")
    public String path = "";
    @DataBoundTokenMacro.Parameter
    public String fileNotFoundMessage = "ERROR: File '%s' does not exist";
    @DataBoundTokenMacro.Parameter
    public int maxLines = -1;
    @DataBoundTokenMacro.Parameter
    public String charSet = Charset.defaultCharset().name();
    public static final String MACRO_NAME = "FILE";

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)context, WorkspaceFileMacro.getWorkspace(context), listener, macroName);
    }

    public MasterToSlaveCallable<String, IOException> getCallable(Run<?, ?> run, String root, TaskListener listener) {
        try {
            EnvVars env = run.getEnvironment(listener);
            this.path = env.expand(this.path);
        }
        catch (Exception e) {
            listener.error("Error retrieving environment: %s", new Object[]{e.getMessage()});
        }
        return new WorkspaceFileMasterToSlaveCallable(root, this.path, this.fileNotFoundMessage, this.charSet, this.maxLines);
    }

    @Override
    public boolean hasNestedContent() {
        return true;
    }

    private static class WorkspaceFileMasterToSlaveCallable
    extends MasterToSlaveCallable<String, IOException> {
        private final String root;
        private final String path;
        private final String fileNotFoundMessage;
        private final String charSet;
        private final int maxLines;

        public WorkspaceFileMasterToSlaveCallable(String root, String path, String fileNotFoundMessage, String charSet, int maxLines) {
            this.root = root;
            this.path = path;
            this.fileNotFoundMessage = fileNotFoundMessage;
            this.charSet = charSet;
            this.maxLines = maxLines;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String call() throws IOException {
            File file = new File(this.root, this.path);
            if (!file.exists()) {
                return String.format(this.fileNotFoundMessage, this.path);
            }
            try {
                Charset charset = Charset.forName(this.charSet);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
                    if (this.maxLines > 0) {
                        String string = reader.lines().limit(this.maxLines).collect(Collectors.joining("\n"));
                        return string;
                    }
                    String string = reader.lines().collect(Collectors.joining("\n"));
                    return string;
                }
            }
            catch (IOException e) {
                return "ERROR: File '" + this.path + "' could not be read";
            }
        }
    }
}

