/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.tokenmacro.Transform;
import org.jenkinsci.plugins.tokenmacro.transform.BeginningOrEndMatchTransorm;
import org.jenkinsci.plugins.tokenmacro.transform.ContentLengthTransform;
import org.jenkinsci.plugins.tokenmacro.transform.SubstringTransform;

public class Parser {
    private static final int MAX_RECURSION_LEVEL = 10;
    private Stack<Transform> transforms = new Stack();
    private StringBuilder output;
    private Run<?, ?> run;
    @CheckForNull
    private FilePath workspace;
    private TaskListener listener;
    private boolean throwException;
    private String stringWithMacro;
    private int recursionLevel;
    private List<TokenMacro> privateTokens;
    private Stack<String> argInfoStack = new Stack();
    private int tokenStartIndex;
    private String tokenName;
    private ListMultimap<String, String> args;

    public Parser(Run<?, ?> run, @CheckForNull FilePath workspace, TaskListener listener, String stringWithMacro, boolean throwException) {
        this.run = run;
        this.workspace = workspace;
        this.listener = listener;
        this.stringWithMacro = stringWithMacro;
        this.output = new StringBuilder();
        this.throwException = throwException;
        this.recursionLevel = 0;
    }

    public Parser(Run<?, ?> run, @CheckForNull FilePath workspace, TaskListener listener, String stringWithMacro, boolean throwException, int recursionLevel) {
        this.run = run;
        this.workspace = workspace;
        this.listener = listener;
        this.stringWithMacro = stringWithMacro;
        this.output = new StringBuilder();
        this.throwException = throwException;
        this.recursionLevel = recursionLevel;
    }

    public static String process(AbstractBuild<?, ?> build, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens) throws MacroEvaluationException {
        return Parser.process(build, build.getWorkspace(), listener, stringWithMacro, throwException, privateTokens);
    }

    public static String process(Run<?, ?> run, @CheckForNull FilePath workspace, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens) throws MacroEvaluationException {
        return Parser.process(run, workspace, listener, stringWithMacro, throwException, privateTokens, 0);
    }

    private static String process(Run<?, ?> run, @CheckForNull FilePath workspace, TaskListener listener, String stringWithMacro, boolean throwException, List<TokenMacro> privateTokens, int recursionLevel) throws MacroEvaluationException {
        if (StringUtils.isBlank((CharSequence)stringWithMacro)) {
            return stringWithMacro;
        }
        Parser p = new Parser(run, workspace, listener, stringWithMacro, throwException);
        p.parse(privateTokens);
        return p.output.toString();
    }

    private void parse(List<TokenMacro> privateTokens) throws MacroEvaluationException {
        this.privateTokens = privateTokens;
        StringCharacterIterator c = new StringCharacterIterator(this.stringWithMacro);
        try {
            while (c.current() != '\uffff') {
                if (c.current() == '$') {
                    this.tokenStartIndex = c.getIndex();
                    this.parseToken(c);
                    continue;
                }
                this.output.append(c.current());
                c.next();
            }
        }
        catch (Throwable e) {
            if (e.getCause() instanceof MacroEvaluationException) {
                throw (MacroEvaluationException)e.getCause();
            }
            throw new MacroEvaluationException("Error processing tokens", e);
        }
    }

    private void parseToken(CharacterIterator c) throws MacroEvaluationException, IOException, InterruptedException {
        if (c.current() != '$') {
            throw new MacroEvaluationException("Missing $ in macro usage");
        }
        char last = c.current();
        c.next();
        if (c.current() == '$') {
            this.parseEscapedToken(c);
        } else if (c.current() == '{') {
            this.parseDelimitedToken(c);
        } else if (Character.isLetter(c.current()) || c.current() == '_') {
            this.parseNonDelimitedToken(c);
        } else {
            this.output.append(last);
            if (c.current() != '\uffff') {
                this.output.append(c.current());
            }
            c.next();
        }
    }

    private void parseEscapedToken(CharacterIterator c) throws MacroEvaluationException {
        if (c.current() != '$') {
            throw new MacroEvaluationException("Missing $ in escaped macro");
        }
        this.output.append(c.current());
        c.next();
        if (c.current() == '{') {
            this.parseEscapedDelimitedToken(c);
        } else {
            this.parseEscapedNonDelimitedToken(c);
        }
    }

    private void parseDelimitedToken(CharacterIterator c) throws MacroEvaluationException, IOException, InterruptedException {
        if (c.current() != '{') {
            throw new MacroEvaluationException("Missing { in delimited macro");
        }
        c.next();
        if (c.current() == '#') {
            this.addTransform(new ContentLengthTransform());
            c.next();
        }
        if (!Character.isLetter(c.current()) && c.current() != '_') {
            this.output.append("${");
            this.output.append(c.current());
            c.next();
            return;
        }
        String token = this.parseIdentifier(c);
        this.startToken(token);
        if (c.current() == ':') {
            this.parseSubstringExpansion(c);
        } else if (c.current() == '#') {
            this.parseBeginningMatchExpansion(c);
        } else if (c.current() == '%') {
            this.parseEndingMatchExpansion(c);
        }
        while (Character.isSpaceChar(c.current())) {
            c.next();
        }
        if (c.current() == ',') {
            this.parseArguments(c);
        }
        if (c.current() != '}') {
            throw new MacroEvaluationException("Missing } in macro usage");
        }
        this.processToken(c.getIndex(), true);
        c.next();
    }

    private void parseNonDelimitedToken(CharacterIterator c) throws MacroEvaluationException, IOException, InterruptedException {
        String token = this.parseIdentifier(c);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            this.startToken(token);
            this.processToken(c.getIndex(), false);
        }
    }

    private void parseEscapedDelimitedToken(CharacterIterator c) throws MacroEvaluationException {
        if (c.current() != '{') {
            throw new MacroEvaluationException("Missing { in macro");
        }
        while (c.current() != '}') {
            this.output.append(c.current());
            c.next();
        }
        this.output.append(c.current());
        c.next();
    }

    private void parseEscapedNonDelimitedToken(CharacterIterator c) throws MacroEvaluationException {
        this.output.append(this.parseIdentifier(c));
    }

    private String parseIdentifier(CharacterIterator c) throws MacroEvaluationException {
        StringBuilder builder = new StringBuilder();
        if (Character.isDigit(c.current()) || c.current() == '.' || c.current() == '-') {
            this.output.append('$');
            this.output.append(this.parseNumericalValue(c));
            return "";
        }
        if (!Character.isLetter(c.current()) && c.current() != '_') {
            throw new MacroEvaluationException("Invalid identifier in macro");
        }
        while (Character.isLetter(c.current()) || Character.isDigit(c.current()) || c.current() == '_') {
            builder.append(c.current());
            c.next();
        }
        return builder.toString();
    }

    private void parseSubstringExpansion(CharacterIterator c) throws MacroEvaluationException {
        if (c.current() != ':') {
            throw new MacroEvaluationException("Missing : in substring expansion for macro: " + this.tokenName);
        }
        boolean isOffsetNegative = false;
        c.next();
        if (c.current() == ' ') {
            c.next();
            if (c.current() != '-') {
                throw new MacroEvaluationException("Invalid negative offset in substring expansion for macro: " + this.tokenName);
            }
            isOffsetNegative = true;
            c.next();
        }
        int offset = (isOffsetNegative ? -1 : 1) * Integer.parseInt(this.parseNumericalValue(c));
        boolean isLengthNegative = false;
        int length = Integer.MAX_VALUE;
        if (c.current() == ':') {
            c.next();
            if (c.current() == '-') {
                isLengthNegative = true;
                c.next();
            }
            length = (isLengthNegative ? -1 : 1) * Integer.parseInt(this.parseNumericalValue(c));
        }
        this.addTransform(new SubstringTransform(offset, length));
    }

    private void parseBeginningMatchExpansion(CharacterIterator c) throws MacroEvaluationException {
        if (c.current() != '#') {
            throw new MacroEvaluationException("Missing # in beginning match expansion for macro: " + this.tokenName);
        }
        c.next();
        String match = this.parseBeginningEndMatchExpansion(c);
        this.addTransform(new BeginningOrEndMatchTransorm(match, true));
    }

    private void parseEndingMatchExpansion(CharacterIterator c) throws MacroEvaluationException {
        if (c.current() != '%') {
            throw new MacroEvaluationException("Missing % in ending match expansion for macro: " + this.tokenName);
        }
        c.next();
        String match = this.parseBeginningEndMatchExpansion(c);
        this.addTransform(new BeginningOrEndMatchTransorm(match, false));
    }

    private String parseBeginningEndMatchExpansion(CharacterIterator c) {
        StringBuilder match = new StringBuilder();
        while (c.current() != '}' && c.current() != ',') {
            if (c.current() == '\\') {
                c.next();
                if (c.current() != '}' && c.current() != ',') {
                    match.append('\\');
                }
                match.append(c.current());
            } else {
                match.append(c.current());
            }
            c.next();
        }
        return match.toString();
    }

    private void parseArguments(CharacterIterator c) throws MacroEvaluationException {
        while (c.current() != '}') {
            if (c.current() != ',') {
                throw new MacroEvaluationException("Missing , for arguments in macro");
            }
            c.next();
            while (Character.isSpaceChar(c.current())) {
                c.next();
            }
            String argName = this.parseIdentifier(c);
            this.argInfoStack.push(argName);
            while (Character.isSpaceChar(c.current())) {
                c.next();
            }
            if (c.current() != '=') {
                throw new MacroEvaluationException("Missing = for argument in macro");
            }
            c.next();
            while (Character.isSpaceChar(c.current())) {
                c.next();
            }
            this.parseArgumentValue(c);
            this.addArg();
            while (Character.isSpaceChar(c.current())) {
                c.next();
            }
        }
    }

    private void parseArgumentValue(CharacterIterator c) throws MacroEvaluationException {
        if (c.current() == '\"') {
            this.parseStringValue(c);
        } else if (c.current() == 't' || c.current() == 'f' || c.current() == 'T' || c.current() == 'F') {
            this.parseBooleanValue(c);
        } else {
            this.argInfoStack.push(this.parseNumericalValue(c));
        }
    }

    private void parseStringValue(CharacterIterator c) throws MacroEvaluationException {
        StringBuilder builder = new StringBuilder();
        if (c.current() != '\"') {
            throw new MacroEvaluationException("Missing \" in argument value for macro: " + this.tokenName);
        }
        c.next();
        boolean escaped = false;
        while (true) {
            if (!(c.current() != '\n' && c.current() != '\r' || escaped)) {
                throw new MacroEvaluationException("Newlines are not allowed in string arguments for macro: " + this.tokenName);
            }
            if (c.current() == '\\') {
                escaped = true;
                builder.append(c.current());
                c.next();
                continue;
            }
            if (c.current() == '\"' && !escaped) break;
            builder.append(c.current());
            c.next();
            escaped = false;
        }
        c.next();
        this.argInfoStack.push(Parser.unescapeString(builder.toString()));
    }

    private void parseBooleanValue(CharacterIterator c) throws MacroEvaluationException {
        char[] matches = null;
        if (Character.toLowerCase(c.current()) == 't') {
            matches = new char[]{'t', 'r', 'u', 'e'};
        } else if (Character.toLowerCase(c.current()) == 'f') {
            matches = new char[]{'f', 'a', 'l', 's', 'e'};
        }
        if (matches == null) {
            throw new MacroEvaluationException("Invalid boolean value for argument for macro: " + this.tokenName);
        }
        for (int i = 0; i < matches.length; ++i) {
            if (c.current() != matches[i]) {
                throw new MacroEvaluationException("Invalid boolean value in macro: " + this.tokenName);
            }
            c.next();
        }
        this.argInfoStack.push(new String(matches));
    }

    private String parseNumericalValue(CharacterIterator c) throws MacroEvaluationException {
        StringBuilder builder;
        block8: {
            block10: {
                block9: {
                    block7: {
                        builder = new StringBuilder();
                        if (c.current() == '-') {
                            builder.append(c.current());
                            c.next();
                        }
                        if (c.current() == '0') break block7;
                        if (!Character.isDigit(c.current())) {
                            throw new MacroEvaluationException("Invalid number value in macro: " + this.tokenName);
                        }
                        while (Character.isDigit(c.current())) {
                            builder.append(c.current());
                            c.next();
                        }
                        break block8;
                    }
                    builder.append(c.current());
                    c.next();
                    if (c.current() != 'x' && c.current() != 'X') break block9;
                    while (Character.isDigit(c.current()) || c.current() >= 'a' && c.current() <= 'f' || c.current() >= 'A' && c.current() <= 'F') {
                        builder.append(c.current());
                        c.next();
                    }
                    break block8;
                }
                if (!Character.isDigit(c.current()) || c.current() < '0' || c.current() > '7') break block10;
                while (Character.isDigit(c.current()) && c.current() >= '0' && c.current() <= '7') {
                    builder.append(c.current());
                    c.next();
                }
                break block8;
            }
            if (!Character.isDigit(c.current())) break block8;
            boolean foundDecimal = false;
            while (Character.isDigit(c.current()) || c.current() == '.' && !foundDecimal) {
                if (c.current() == '.') {
                    foundDecimal = true;
                }
                builder.append(c.current());
                c.next();
            }
        }
        return builder.toString();
    }

    boolean addTransform(Transform t) {
        this.transforms.push(t);
        return true;
    }

    boolean processToken(int currentIndex, boolean isDelimited) throws IOException, InterruptedException, MacroEvaluationException {
        String replacement = null;
        ArrayList<TokenMacro> all = new ArrayList<TokenMacro>((Collection<TokenMacro>)TokenMacro.all());
        if (this.privateTokens != null) {
            all.addAll(this.privateTokens.stream().filter(x -> x != null).collect(Collectors.toList()));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry e : this.args.entries()) {
            map.put((String)e.getKey(), (String)e.getValue());
        }
        for (TokenMacro tm : all) {
            if (!tm.acceptsMacroName(this.tokenName)) continue;
            try {
                if (this.run instanceof AbstractBuild) {
                    AbstractBuild build = (AbstractBuild)this.run;
                    replacement = tm.evaluate(build, this.listener, this.tokenName, map, this.args);
                } else {
                    replacement = tm.evaluate(this.run, this.workspace, this.listener, this.tokenName, map, this.args);
                }
                if (!tm.hasNestedContent() || this.recursionLevel >= 10) break;
                replacement = Parser.process(this.run, this.workspace, this.listener, replacement, this.throwException, this.privateTokens, this.recursionLevel + 1);
            }
            catch (MacroEvaluationException e) {
                if (this.throwException) {
                    throw e;
                }
                replacement = String.format("[Error replacing '%s' - %s]", this.tokenName, e.getMessage());
            }
            break;
        }
        if (replacement == null && this.throwException) {
            throw new MacroEvaluationException(String.format("Unrecognized macro '%s' in '%s'", this.tokenName, this.stringWithMacro));
        }
        if (replacement == null && !this.throwException) {
            this.output.append(this.stringWithMacro.substring(this.tokenStartIndex, currentIndex + (isDelimited ? 1 : 0)));
        } else if (replacement != null) {
            while (this.transforms != null && this.transforms.size() > 0) {
                Transform t = this.transforms.pop();
                replacement = t.transform(replacement);
            }
            this.output.append(replacement);
        }
        this.tokenName = "";
        this.args = null;
        return true;
    }

    boolean startToken(String tokenName) {
        this.tokenName = tokenName;
        if (this.args == null) {
            this.args = Multimaps.newListMultimap(new TreeMap(), () -> new ArrayList());
        } else {
            this.args.clear();
        }
        return true;
    }

    boolean addArg() {
        String value = this.argInfoStack.pop();
        String name = this.argInfoStack.pop();
        this.args.put((Object)name, (Object)value);
        return true;
    }

    public static String unescapeString(String escapedString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < escapedString.length(); ++i) {
            char c = escapedString.charAt(i);
            if (c == '\\') {
                sb.append(Parser.unescapeChar(escapedString.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static char unescapeChar(char escapedChar) {
        switch (escapedChar) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
        }
        return escapedChar;
    }
}

