/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class TokenMacroStep
extends Step {
    @NonNull
    private final String stringWithMacro;

    @DataBoundConstructor
    public TokenMacroStep(@NonNull String stringWithMacro) {
        this.stringWithMacro = stringWithMacro;
    }

    public String getStringWithMacro() {
        return this.stringWithMacro;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.stringWithMacro, context);
    }

    private static class Execution
    extends SynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient String stringWithMacro;

        Execution(String stringWithMacro, StepContext context) {
            super(context);
            this.stringWithMacro = stringWithMacro;
        }

        protected String run() throws Exception {
            return TokenMacro.expand((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (TaskListener)this.getContext().get(TaskListener.class), this.stringWithMacro);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "tm";
        }

        public String getDisplayName() {
            return "Expand a string containing macros";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, Run.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }
    }
}

