/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class BuildCauseMacro
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "BUILD_CAUSE";
    public static final String ALTERNATE_MACRO_NAME = "CAUSE";
    @DataBoundTokenMacro.Parameter
    public String data = null;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME) || macroName.equals(ALTERNATE_MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        ArrayList<String> macroNames = new ArrayList<String>();
        Collections.addAll(macroNames, MACRO_NAME, ALTERNATE_MACRO_NAME);
        return macroNames;
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)build, null, listener, macroName);
    }

    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        List<Object> causes = new LinkedList<Cause>();
        CauseAction causeAction = (CauseAction)run.getAction(CauseAction.class);
        if (causeAction != null) {
            causes = causeAction.getCauses();
        }
        return this.formatCauses(causes);
    }

    private String formatCauses(List<Cause> causes) {
        if (causes.isEmpty()) {
            return "N/A";
        }
        LinkedList<Object> causeData = new LinkedList<Object>();
        for (Cause cause : causes) {
            if (this.data != null) {
                if (!(cause instanceof Cause.UpstreamCause)) continue;
                Cause.UpstreamCause upstreamCause = (Cause.UpstreamCause)cause;
                if (this.data.equals("BUILD_URL")) {
                    causeData.add(upstreamCause.getUpstreamUrl());
                    continue;
                }
                if (this.data.equals("PROJECT_NAME")) {
                    causeData.add(upstreamCause.getUpstreamProject());
                    continue;
                }
                if (!this.data.equals("BUILD_NUMBER")) continue;
                causeData.add("" + upstreamCause.getUpstreamBuild());
                continue;
            }
            causeData.add(cause.getShortDescription());
        }
        return StringUtils.join(causeData, (String)", ");
    }
}

