/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.lib.versionnumber;

import hudson.util.VersionNumber;
import javax.annotation.Nonnull;

public class JavaSpecificationVersion
extends VersionNumber {
    private static final String JAVA_SPEC_VERSION_PROPERTY_NAME = "java.specification.version";
    public static final JavaSpecificationVersion JAVA_5 = new JavaSpecificationVersion("1.5");
    public static final JavaSpecificationVersion JAVA_6 = new JavaSpecificationVersion("1.6");
    public static final JavaSpecificationVersion JAVA_7 = new JavaSpecificationVersion("1.7");
    public static final JavaSpecificationVersion JAVA_8 = new JavaSpecificationVersion("1.8");
    public static final JavaSpecificationVersion JAVA_9 = new JavaSpecificationVersion("9");
    public static final JavaSpecificationVersion JAVA_10 = new JavaSpecificationVersion("10");
    public static final JavaSpecificationVersion JAVA_11 = new JavaSpecificationVersion("11");
    public static final JavaSpecificationVersion JAVA_12 = new JavaSpecificationVersion("12");
    public static final JavaSpecificationVersion JAVA_13 = new JavaSpecificationVersion("13");

    public JavaSpecificationVersion(@Nonnull String version) throws NumberFormatException {
        super(JavaSpecificationVersion.normalizeVersion(version));
    }

    @Nonnull
    private static String normalizeVersion(@Nonnull String input) throws NumberFormatException {
        int majorVersion;
        if ((input = input.trim()).startsWith("1.")) {
            String[] split = input.split("\\.");
            if (split.length != 2) {
                throw new NumberFormatException("Malformed old Java Specification Version. There should be exactly one dot and something after it: " + input);
            }
            input = split[1];
        }
        if ((majorVersion = Integer.parseInt(input)) > 8) {
            return input;
        }
        return "1." + input;
    }

    @Nonnull
    public static JavaSpecificationVersion forCurrentJVM() throws NumberFormatException {
        String value = System.getProperty(JAVA_SPEC_VERSION_PROPERTY_NAME);
        if (value == null) {
            throw new IllegalStateException("Missing mandatory JVM system property: java.specification.version");
        }
        return new JavaSpecificationVersion(value);
    }
}

