/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.when.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import org.codehaus.groovy.ast.expr.Expression;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTWhenContent;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.ASTParserUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditional;
import org.jenkinsci.plugins.pipeline.modeldefinition.when.DeclarativeStageConditionalDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class EqualsConditional
extends DeclarativeStageConditional<EqualsConditional> {
    private final Object expected;
    private final Object actual;

    @DataBoundConstructor
    public EqualsConditional(Object expected, Object actual) {
        this.expected = expected;
        this.actual = actual;
    }

    public Object getActual() {
        return this.actual;
    }

    public Object getExpected() {
        return this.expected;
    }

    @Extension
    @Symbol(value={"equals"})
    public static class DescriptorImpl
    extends DeclarativeStageConditionalDescriptor<EqualsConditional> {
        @NonNull
        public String getDisplayName() {
            return "Execute the stage if two values are equal";
        }

        public boolean inDirectiveGenerator() {
            return false;
        }

        public Expression transformToRuntimeAST(@CheckForNull ModelASTWhenContent original) {
            return ASTParserUtils.transformWhenContentToRuntimeAST(original);
        }
    }
}

