/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.abi.tools.api.AbiToolsInterface;
import org.jetbrains.kotlin.abi.tools.api.v2.AbiToolsV2;
import org.jetbrains.kotlin.abi.tools.v2.ToolsV2;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/abi/tools/AbiTools;", "Lorg/jetbrains/kotlin/abi/tools/api/AbiToolsInterface;", "<init>", "()V", "v2", "Lorg/jetbrains/kotlin/abi/tools/api/v2/AbiToolsV2;", "getV2", "()Lorg/jetbrains/kotlin/abi/tools/api/v2/AbiToolsV2;", "filesDiff", "", "expectedFile", "Ljava/io/File;", "actualFile", "abi-tools"})
public final class AbiTools
implements AbiToolsInterface {
    @NotNull
    public static final AbiTools INSTANCE = new AbiTools();
    @NotNull
    private static final AbiToolsV2 v2 = ToolsV2.INSTANCE;

    private AbiTools() {
    }

    @NotNull
    public AbiToolsV2 getV2() {
        return v2;
    }

    @Nullable
    public String filesDiff(@NotNull File expectedFile, @NotNull File actualFile) {
        Intrinsics.checkNotNullParameter((Object)expectedFile, (String)"expectedFile");
        Intrinsics.checkNotNullParameter((Object)actualFile, (String)"actualFile");
        String expectedText = FilesKt.readText$default((File)expectedFile, null, (int)1, null);
        String actualText = FilesKt.readText$default((File)actualFile, null, (int)1, null);
        List expectedLines = StringsKt.lines((CharSequence)expectedText);
        List actualLines = StringsKt.lines((CharSequence)actualText);
        if (Intrinsics.areEqual((Object)expectedLines, (Object)actualLines)) {
            return null;
        }
        Patch patch = DiffUtils.diff((List)expectedLines, (List)actualLines);
        List diff = UnifiedDiffUtils.generateUnifiedDiff((String)expectedFile.toString(), (String)actualFile.toString(), (List)expectedLines, (Patch)patch, (int)3);
        Intrinsics.checkNotNull((Object)diff);
        return CollectionsKt.joinToString$default((Iterable)diff, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }
}

