/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.ShortenStrategy;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.components.AdditionalImports;
import org.jetbrains.kotlin.analysis.api.fir.components.KaFirReferenceShortenerKt;
import org.jetbrains.kotlin.analysis.api.fir.components.ShortenKDocQualifier;
import org.jetbrains.kotlin.analysis.api.fir.references.KDocReferenceResolver;
import org.jetbrains.kotlin.analysis.api.fir.utils.KtSymbolUtilsKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaSymbolWithKind;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016JH\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t2\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000b0\tH\u0002J&\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\"H\u0002J\u0014\u0010#\u001a\u00020\u001a*\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KDocQualifiersToShortenCollector;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "selection", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "additionalImports", "Lorg/jetbrains/kotlin/analysis/api/fir/components/AdditionalImports;", "classShortenStrategy", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenStrategy;", "callableShortenStrategy", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lcom/intellij/openapi/util/TextRange;Lorg/jetbrains/kotlin/analysis/api/fir/components/AdditionalImports;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "kDocQualifiersToShorten", "", "Lorg/jetbrains/kotlin/analysis/api/fir/components/ShortenKDocQualifier;", "getKDocQualifiersToShorten", "()Ljava/util/List;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "shouldShortenKDocQualifier", "", "kDocName", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "canShorten", "fqNameToShorten", "Lorg/jetbrains/kotlin/name/FqName;", "fqNameOfAvailableSymbol", "getShortenStrategy", "Lkotlin/Function0;", "isInNewImports", "addKDocQualifierToShorten", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKaFirReferenceShortener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KDocQualifiersToShortenCollector\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,1606:1\n20#2,2:1607\n20#2,2:1609\n*S KotlinDebug\n*F\n+ 1 KaFirReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/fir/components/KDocQualifiersToShortenCollector\n*L\n1550#1:1607,2\n1554#1:1609,2\n*E\n"})
final class KDocQualifiersToShortenCollector
extends KtVisitorVoid {
    @NotNull
    private final KaFirSession analysisSession;
    @NotNull
    private final TextRange selection;
    @NotNull
    private final AdditionalImports additionalImports;
    @NotNull
    private final Function1<FirClassLikeSymbol<?>, ShortenStrategy> classShortenStrategy;
    @NotNull
    private final Function1<FirCallableSymbol<?>, ShortenStrategy> callableShortenStrategy;
    @NotNull
    private final List<ShortenKDocQualifier> kDocQualifiersToShorten;

    public KDocQualifiersToShortenCollector(@NotNull KaFirSession analysisSession, @NotNull TextRange selection, @NotNull AdditionalImports additionalImports, @NotNull Function1<? super FirClassLikeSymbol<?>, ? extends ShortenStrategy> classShortenStrategy, @NotNull Function1<? super FirCallableSymbol<?>, ? extends ShortenStrategy> callableShortenStrategy) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)additionalImports, (String)"additionalImports");
        Intrinsics.checkNotNullParameter(classShortenStrategy, (String)"classShortenStrategy");
        Intrinsics.checkNotNullParameter(callableShortenStrategy, (String)"callableShortenStrategy");
        this.analysisSession = analysisSession;
        this.selection = selection;
        this.additionalImports = additionalImports;
        this.classShortenStrategy = classShortenStrategy;
        this.callableShortenStrategy = callableShortenStrategy;
        this.kDocQualifiersToShorten = new ArrayList();
    }

    @NotNull
    public final List<ShortenKDocQualifier> getKDocQualifiersToShorten() {
        return this.kDocQualifiersToShorten;
    }

    public void visitElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.getTextRange().intersects(this.selection)) {
            return;
        }
        if (!this.selection.contains(element.getTextRange()) || !(element instanceof KDocName)) {
            element.acceptChildren((PsiElementVisitor)this);
            return;
        }
        if (((KDocName)element).getQualifier() == null) {
            return;
        }
        boolean shouldShortenKDocQualifier = this.shouldShortenKDocQualifier((KDocName)element, this.additionalImports, arg_0 -> KDocQualifiersToShortenCollector.visitElement$lambda$0(this, arg_0), arg_0 -> KDocQualifiersToShortenCollector.visitElement$lambda$1(this, arg_0));
        if (shouldShortenKDocQualifier) {
            this.addKDocQualifierToShorten((KDocName)element);
        } else {
            ((KDocName)element).acceptChildren((PsiElementVisitor)this);
            KDocName kDocName = ((KDocName)element).getQualifier();
            if (Intrinsics.areEqual((Object)(kDocName != null ? kDocName.getNameText() : null), (Object)"_root_ide_package_")) {
                this.addKDocQualifierToShorten((KDocName)element);
            }
        }
    }

    private final boolean shouldShortenKDocQualifier(KDocName kDocName, AdditionalImports additionalImports, Function1<? super FirClassLikeSymbol<?>, ? extends ShortenStrategy> classShortenStrategy, Function1<? super FirCallableSymbol<?>, ? extends ShortenStrategy> callableShortenStrategy) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        Object v5;
        KaSymbolWithKind kaSymbolWithKind;
        FqName fqName;
        block8: {
            Object availableCallable;
            Object v4;
            Object element$iv;
            boolean $i$f$firstIsInstanceOrNull;
            Object $this$firstIsInstanceOrNull$iv;
            Collection<KaSymbol> resolvedSymbols;
            block7: {
                KtAnnotated ktAnnotated;
                KtDeclaration owner;
                fqName = KaFirReferenceShortenerKt.access$dropFakeRootPrefixIfPresent(kDocName.getQualifiedNameAsFqName());
                if (this.isInNewImports(fqName, additionalImports)) {
                    return true;
                }
                KaFirSession $this$shouldShortenKDocQualifier_u24lambda_u242 = this.analysisSession;
                boolean bl = false;
                FqName fqName2 = FqName.topLevel((Name)fqName.shortName());
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"topLevel(...)");
                Object shortFqName = fqName2;
                KtDeclaration ktDeclaration = owner = kDocName.getContainingDoc().getOwner();
                if (ktDeclaration != null) {
                    ktAnnotated = (KtAnnotated)ktDeclaration;
                } else {
                    KtFile ktFile = kDocName.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
                    ktAnnotated = (KtAnnotated)ktFile;
                }
                KtAnnotated contextElement = ktAnnotated;
                resolvedSymbols = KDocReferenceResolver.INSTANCE.resolveKdocFqName$analysis_api_fir($this$shouldShortenKDocQualifier_u24lambda_u242.getUseSiteSession(), (FqName)shortFqName, (FqName)shortFqName, (KtElement)contextElement);
                $this$firstIsInstanceOrNull$iv = (FirCallableSymbol<?>)resolvedSymbols;
                $i$f$firstIsInstanceOrNull = false;
                shortFqName = $this$firstIsInstanceOrNull$iv.iterator();
                while (shortFqName.hasNext()) {
                    element$iv = shortFqName.next();
                    if (!(element$iv instanceof KaCallableSymbol)) continue;
                    v4 = element$iv;
                    break block7;
                }
                v4 = null;
            }
            kaSymbolWithKind = v4;
            if (kaSymbolWithKind != null && ($this$firstIsInstanceOrNull$iv = KtSymbolUtilsKt.getFirSymbol(kaSymbolWithKind)) != null) {
                availableCallable = $this$firstIsInstanceOrNull$iv;
                boolean bl = false;
                return this.canShorten(fqName, availableCallable.getCallableId().asSingleFqName(), (Function0<? extends ShortenStrategy>)((Function0)() -> KDocQualifiersToShortenCollector.shouldShortenKDocQualifier$lambda$4$lambda$3(callableShortenStrategy, (FirCallableSymbol)availableCallable)));
            }
            $this$firstIsInstanceOrNull$iv = resolvedSymbols;
            $i$f$firstIsInstanceOrNull = false;
            availableCallable = $this$firstIsInstanceOrNull$iv.iterator();
            while (availableCallable.hasNext()) {
                element$iv = availableCallable.next();
                if (!(element$iv instanceof KaClassLikeSymbol)) continue;
                v5 = element$iv;
                break block8;
            }
            v5 = null;
        }
        kaSymbolWithKind = v5;
        if (kaSymbolWithKind != null && (firClassLikeSymbol = KtSymbolUtilsKt.getFirSymbol((KaClassLikeSymbol)kaSymbolWithKind)) != null) {
            FirClassLikeSymbol<?> availableClassifier = firClassLikeSymbol;
            boolean bl = false;
            return this.canShorten(fqName, availableClassifier.getClassId().asSingleFqName(), (Function0<? extends ShortenStrategy>)((Function0)() -> KDocQualifiersToShortenCollector.shouldShortenKDocQualifier$lambda$6$lambda$5(classShortenStrategy, availableClassifier)));
        }
        return false;
    }

    private final boolean canShorten(FqName fqNameToShorten, FqName fqNameOfAvailableSymbol, Function0<? extends ShortenStrategy> getShortenStrategy) {
        return Intrinsics.areEqual((Object)fqNameToShorten, (Object)fqNameOfAvailableSymbol) && getShortenStrategy.invoke() != ShortenStrategy.DO_NOT_SHORTEN;
    }

    private final boolean isInNewImports(FqName $this$isInNewImports, AdditionalImports additionalImports) {
        return additionalImports.getSimpleImports().contains($this$isInNewImports) || additionalImports.getStarImports().contains($this$isInNewImports.parent());
    }

    private final void addKDocQualifierToShorten(KDocName kDocName) {
        this.kDocQualifiersToShorten.add(new ShortenKDocQualifier(kDocName));
    }

    private static final ShortenStrategy visitElement$lambda$0(KDocQualifiersToShortenCollector this$0, FirClassLikeSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ShortenStrategy)((Object)this$0.classShortenStrategy.invoke((Object)it));
    }

    private static final ShortenStrategy visitElement$lambda$1(KDocQualifiersToShortenCollector this$0, FirCallableSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (ShortenStrategy)((Object)this$0.callableShortenStrategy.invoke((Object)it));
    }

    private static final ShortenStrategy shouldShortenKDocQualifier$lambda$4$lambda$3(Function1 $callableShortenStrategy, FirCallableSymbol $availableCallable) {
        return (ShortenStrategy)((Object)$callableShortenStrategy.invoke((Object)$availableCallable));
    }

    private static final ShortenStrategy shouldShortenKDocQualifier$lambda$6$lambda$5(Function1 $classShortenStrategy, FirClassLikeSymbol $availableClassifier) {
        return (ShortenStrategy)((Object)$classShortenStrategy.invoke((Object)$availableClassifier));
    }
}

