/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.SourcesUtilsKt;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTimeMetric;
import org.jetbrains.kotlin.build.report.metrics.DoNothingBuildMetricsReporter;
import org.jetbrains.kotlin.buildtools.api.CompilationResult;
import org.jetbrains.kotlin.buildtools.api.CompilationService;
import org.jetbrains.kotlin.buildtools.api.CompilerArgumentsParseException;
import org.jetbrains.kotlin.buildtools.api.CompilerExecutionStrategyConfiguration;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.api.jvm.ClassSnapshotGranularity;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathSnapshotBasedIncrementalCompilationApproachParameters;
import org.jetbrains.kotlin.buildtools.api.jvm.ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.api.jvm.IncrementalJvmCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.internal.AggregatedIcConfiguration;
import org.jetbrains.kotlin.buildtools.internal.BuildToolsApiBuildICReporter;
import org.jetbrains.kotlin.buildtools.internal.ClasspathEntrySnapshotImpl;
import org.jetbrains.kotlin.buildtools.internal.CompilationServiceImplKt;
import org.jetbrains.kotlin.buildtools.internal.CompilerExecutionStrategy;
import org.jetbrains.kotlin.buildtools.internal.CompilerExecutionStrategyConfigurationImpl;
import org.jetbrains.kotlin.buildtools.internal.ConfigurationAdaptersKt;
import org.jetbrains.kotlin.buildtools.internal.DaemonAdaptersKt;
import org.jetbrains.kotlin.buildtools.internal.DaemonCompilationResults;
import org.jetbrains.kotlin.buildtools.internal.IcAdaptersKt;
import org.jetbrains.kotlin.buildtools.internal.JvmCompilationConfigurationImpl;
import org.jetbrains.kotlin.buildtools.internal.KotlinLoggerMessageCollectorAdapter;
import org.jetbrains.kotlin.buildtools.internal.scripting.compiler.plugin.impl.ErrorReportingKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.buildtools.internal.scripting.definitions.ScriptDefinitionsFromClasspathDiscoverySource;
import org.jetbrains.kotlin.buildtools.internal.scripting.jvm.JvmScriptingHostConfigurationKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CompatKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.RestPropMapper;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.CompilerRunnerUtils;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalCompilationFeatures;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunnerKt;
import org.jetbrains.kotlin.incremental.IncrementalFirJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshotter;
import org.jetbrains.kotlin.incremental.storage.FileLocations;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J<\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\b\u0010 \u001a\u00020\u001fH\u0002J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bH\u0016JB\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00122\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0)2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002J\u0016\u0010*\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002JD\u0010+\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002J\b\u0010.\u001a\u00020\u001dH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/CompilationServiceImpl;", "Lorg/jetbrains/kotlin/buildtools/api/CompilationService;", "<init>", "()V", "buildIdToSessionFlagFile", "", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "Ljava/io/File;", "calculateClasspathSnapshot", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClasspathEntrySnapshot;", "classpathEntry", "granularity", "Lorg/jetbrains/kotlin/buildtools/api/jvm/ClassSnapshotGranularity;", "parseInlinedLocalClasses", "", "makeCompilerExecutionStrategyConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/CompilerExecutionStrategyConfigurationImpl;", "makeJvmCompilationConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/JvmCompilationConfigurationImpl;", "compileJvm", "Lorg/jetbrains/kotlin/buildtools/api/CompilationResult;", "projectId", "strategyConfig", "Lorg/jetbrains/kotlin/buildtools/api/CompilerExecutionStrategyConfiguration;", "compilationConfig", "Lorg/jetbrains/kotlin/buildtools/api/jvm/JvmCompilationConfiguration;", "sources", "", "arguments", "", "finishProjectCompilation", "", "clearJarCaches", "getCustomKotlinScriptFilenameExtensions", "", "classpath", "compileInProcess", "loggerAdapter", "Lorg/jetbrains/kotlin/buildtools/internal/KotlinLoggerMessageCollectorAdapter;", "compilationConfiguration", "kotlinFilenameExtensions", "", "checkJvmFirRequirements", "compileWithinDaemon", "daemonConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/CompilerExecutionStrategy$Daemon;", "getCompilerVersion", "kotlin-build-tools-impl"})
@SourceDebugExtension(value={"SMAP\nCompilationServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationServiceImpl.kt\norg/jetbrains/kotlin/buildtools/internal/CompilationServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,335:1\n3347#2,10:336\n777#2:349\n873#2,2:350\n1586#2:352\n1661#2,3:353\n1586#2:356\n1661#2,3:357\n1586#2:363\n1661#2,3:364\n1184#3,3:346\n1#4:360\n37#5,2:361\n*S KotlinDebug\n*F\n+ 1 CompilationServiceImpl.kt\norg/jetbrains/kotlin/buildtools/internal/CompilationServiceImpl\n*L\n108#1:336,10\n181#1:349\n181#1:350,2\n181#1:352\n181#1:353,3\n226#1:356\n226#1:357,3\n308#1:363\n308#1:364,3\n154#1:346,3\n308#1:361,2\n*E\n"})
public final class CompilationServiceImpl
implements CompilationService {
    @NotNull
    public static final CompilationServiceImpl INSTANCE = new CompilationServiceImpl();
    @NotNull
    private static final Map<ProjectId, File> buildIdToSessionFlagFile = new ConcurrentHashMap();

    private CompilationServiceImpl() {
    }

    @NotNull
    public ClasspathEntrySnapshot calculateClasspathSnapshot(@NotNull File classpathEntry, @NotNull ClassSnapshotGranularity granularity, boolean parseInlinedLocalClasses) {
        Intrinsics.checkNotNullParameter((Object)classpathEntry, (String)"classpathEntry");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        return new ClasspathEntrySnapshotImpl(ClasspathEntrySnapshotter.INSTANCE.snapshot(classpathEntry, new ClasspathEntrySnapshotter.Settings(granularity, parseInlinedLocalClasses), (BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE));
    }

    @NotNull
    public ClasspathEntrySnapshot calculateClasspathSnapshot(@NotNull File classpathEntry, @NotNull ClassSnapshotGranularity granularity) {
        Intrinsics.checkNotNullParameter((Object)classpathEntry, (String)"classpathEntry");
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        return this.calculateClasspathSnapshot(classpathEntry, granularity, true);
    }

    @NotNull
    public CompilerExecutionStrategyConfigurationImpl makeCompilerExecutionStrategyConfiguration() {
        return new CompilerExecutionStrategyConfigurationImpl();
    }

    @NotNull
    public JvmCompilationConfigurationImpl makeJvmCompilationConfiguration() {
        return new JvmCompilationConfigurationImpl(null, null, 3, null);
    }

    @NotNull
    public CompilationResult compileJvm(@NotNull ProjectId projectId, @NotNull CompilerExecutionStrategyConfiguration strategyConfig, @NotNull JvmCompilationConfiguration compilationConfig, @NotNull List<? extends File> sources, @NotNull List<String> arguments) {
        CompilationResult compilationResult;
        CompilerExecutionStrategy selectedStrategy;
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)strategyConfig, (String)"strategyConfig");
        Intrinsics.checkNotNullParameter((Object)compilationConfig, (String)"compilationConfig");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        if (!(strategyConfig instanceof CompilerExecutionStrategyConfigurationImpl)) {
            boolean $i$a$-check-CompilationServiceImpl$compileJvm$32 = false;
            String $i$a$-check-CompilationServiceImpl$compileJvm$32 = "Initial strategy configuration object must be acquired from the `makeCompilerExecutionStrategyConfiguration` method.";
            throw new IllegalStateException($i$a$-check-CompilationServiceImpl$compileJvm$32.toString());
        }
        if (!(compilationConfig instanceof JvmCompilationConfigurationImpl)) {
            boolean $i$a$-check-CompilationServiceImpl$compileJvm$42 = false;
            String $i$a$-check-CompilationServiceImpl$compileJvm$42 = "Initial JVM compilation configuration object must be acquired from the `makeJvmCompilationConfiguration` method.";
            throw new IllegalStateException($i$a$-check-CompilationServiceImpl$compileJvm$42.toString());
        }
        KotlinLoggerMessageCollectorAdapter loggerAdapter = new KotlinLoggerMessageCollectorAdapter(((JvmCompilationConfigurationImpl)compilationConfig).getLogger());
        Set kotlinFilenameExtensions = SetsKt.plus((Set)SourcesUtilsKt.getDEFAULT_KOTLIN_SOURCE_FILES_EXTENSIONS(), (Iterable)((JvmCompilationConfigurationImpl)compilationConfig).getKotlinScriptFilenameExtensions());
        Iterable $this$partition$iv = sources;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            boolean bl2 = FileUtilsKt.isJavaFile((File)it) || FileUtilsKt.isKotlinFile((File)it, (Collection)kotlinFilenameExtensions) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List filteredSources = (List)pair.component1();
        List unknownSources = (List)pair.component2();
        if (!((Collection)unknownSources).isEmpty()) {
            ((JvmCompilationConfigurationImpl)compilationConfig).getLogger().warn("Sources with unknown extensions were passed, they will be skipped: " + CollectionsKt.joinToString$default((Iterable)unknownSources, null, null, null, (int)0, null, null, (int)63, null));
        }
        if ((selectedStrategy = ((CompilerExecutionStrategyConfigurationImpl)strategyConfig).getSelectedStrategy$kotlin_build_tools_impl()) instanceof CompilerExecutionStrategy.InProcess) {
            compilationResult = this.compileInProcess(loggerAdapter, (JvmCompilationConfigurationImpl)compilationConfig, kotlinFilenameExtensions, filteredSources, arguments);
        } else if (selectedStrategy instanceof CompilerExecutionStrategy.Daemon) {
            compilationResult = this.compileWithinDaemon(projectId, loggerAdapter, (CompilerExecutionStrategy.Daemon)selectedStrategy, (JvmCompilationConfigurationImpl)compilationConfig, filteredSources, arguments);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return compilationResult;
    }

    public void finishProjectCompilation(@NotNull ProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        this.clearJarCaches();
        File file = buildIdToSessionFlagFile.remove(projectId);
        if (file == null) {
            return;
        }
        File file2 = file;
        file2.delete();
    }

    private final void clearJarCaches() {
        block2: {
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment;
            ZipHandler.clearFileAccessorCache();
            KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment2 = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
            if (kotlinCoreApplicationEnvironment2 == null) break block2;
            KotlinCoreApplicationEnvironment $this$clearJarCaches_u24lambda_u240 = kotlinCoreApplicationEnvironment = kotlinCoreApplicationEnvironment2;
            boolean bl = false;
            VirtualFileSystem virtualFileSystem = $this$clearJarCaches_u24lambda_u240.getJarFileSystem();
            CoreJarFileSystem coreJarFileSystem = virtualFileSystem instanceof CoreJarFileSystem ? (CoreJarFileSystem)virtualFileSystem : null;
            if (coreJarFileSystem != null) {
                coreJarFileSystem.clearHandlersCache();
            }
            virtualFileSystem = $this$clearJarCaches_u24lambda_u240.getJrtFileSystem();
            CoreJrtFileSystem coreJrtFileSystem = virtualFileSystem instanceof CoreJrtFileSystem ? (CoreJrtFileSystem)virtualFileSystem : null;
            if (coreJrtFileSystem != null) {
                coreJrtFileSystem.clearRoots();
            }
            $this$clearJarCaches_u24lambda_u240.idleCleanup();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getCustomKotlinScriptFilenameExtensions(@NotNull List<? extends File> classpath) {
        void destination$iv;
        void $this$mapTo$iv;
        Sequence<ScriptDefinition> definitions2;
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Sequence<ScriptDefinition> sequence = definitions2 = new ScriptDefinitionsFromClasspathDiscoverySource(classpath, JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration(), ErrorReportingKt.getReporter((MessageCollector)new PrintingMessageCollector(System.out, MessageRenderer.WITHOUT_PATHS, false))).getDefinitions();
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            ScriptDefinition scriptDefinition = (ScriptDefinition)((Object)item$iv);
            void var10_10 = destination$iv;
            boolean bl = false;
            var10_10.add(it.getFileExtension());
        }
        return destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult compileInProcess(KotlinLoggerMessageCollectorAdapter loggerAdapter, JvmCompilationConfigurationImpl compilationConfiguration, Set<String> kotlinFilenameExtensions, List<? extends File> sources, List<String> arguments) {
        CompilationResult compilationResult;
        IncrementalJvmCompilationConfiguration<?> options;
        AggregatedIcConfiguration<ClasspathSnapshotBasedIncrementalCompilationApproachParameters> aggregatedIcConfiguration;
        loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().debug("Compiling using the in-process strategy");
        CompatKt.setupIdeaStandaloneExecution();
        K2JVMCompiler compiler = new K2JVMCompiler();
        K2JVMCompilerArguments parsedArguments = compiler.createArguments();
        ParseCommandLineArgumentsKt.parseCommandLineArguments$default(arguments, (CommonToolArguments)((CommonToolArguments)parsedArguments), (boolean)false, (int)4, null);
        String string = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)parsedArguments.getErrors());
        if (string != null) {
            String it = string;
            boolean bl = false;
            throw new CompilerArgumentsParseException(it);
        }
        AggregatedIcConfiguration<ClasspathSnapshotBasedIncrementalCompilationApproachParameters> aggregatedIcConfiguration2 = aggregatedIcConfiguration = compilationConfiguration.getAggregatedIcConfiguration$kotlin_build_tools_impl();
        Object object = options = aggregatedIcConfiguration2 != null ? aggregatedIcConfiguration2.getOptions() : null;
        if (options instanceof ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            File it;
            void $this$filterTo$iv$iv;
            List allSources = CollectionsKt.plus((Collection)IncrementalCompilerRunnerKt.extractKotlinSourcesFromFreeCompilerArguments((CommonCompilerArguments)((CommonCompilerArguments)parsedArguments), kotlinFilenameExtensions, (boolean)true), (Iterable)sources);
            Iterable $this$filter$iv = allSources;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (File)element$iv$iv;
                boolean bl = false;
                if (!FileUtilsKt.isJavaFile((File)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAbsolutePath());
            }
            List javaSources = (List)destination$iv$iv;
            AggregatedIcConfiguration<ClasspathSnapshotBasedIncrementalCompilationApproachParameters> aggregatedIcConfiguration3 = aggregatedIcConfiguration;
            Intrinsics.checkNotNull(aggregatedIcConfiguration3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.buildtools.internal.AggregatedIcConfiguration<org.jetbrains.kotlin.buildtools.api.jvm.ClasspathSnapshotBasedIncrementalCompilationApproachParameters>");
            ClasspathChanges.ClasspathSnapshotEnabled classpathChanges = IcAdaptersKt.getClasspathChanges(aggregatedIcConfiguration3);
            BuildReporter buildReporter = new BuildReporter((ICReporter)new BuildToolsApiBuildICReporter(loggerAdapter.getKotlinLogger$kotlin_build_tools_impl(), ((ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration)options).getRootProjectDir()), (BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE);
            boolean verifiedPreciseJavaTracking = CompilerRunnerUtils.disablePreciseJavaTrackingIfK2((K2JVMCompilerArguments)parsedArguments, (boolean)((ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration)options).getPreciseJavaTrackingEnabled());
            IncrementalCompilationFeatures icFeatures = IncrementalCompilationFeatures.copy$default((IncrementalCompilationFeatures)ConfigurationAdaptersKt.extractIncrementalCompilationFeatures(options), (boolean)verifiedPreciseJavaTracking, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)62, null);
            IncrementalJvmCompilerRunner incrementalCompiler = ((ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration)options).isUsingFirRunner() && this.checkJvmFirRequirements(arguments) ? (IncrementalJvmCompilerRunner)new IncrementalFirJvmCompilerRunner(aggregatedIcConfiguration.getWorkingDir(), buildReporter, (Collection)((ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration)options).getOutputDirs(), (ClasspathChanges)classpathChanges, kotlinFilenameExtensions, icFeatures, false, null, 192, null) : new IncrementalJvmCompilerRunner(aggregatedIcConfiguration.getWorkingDir(), buildReporter, (Collection)((ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration)options).getOutputDirs(), (ClasspathChanges)classpathChanges, kotlinFilenameExtensions, icFeatures, false, null, 192, null);
            File rootProjectDir = ((ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration)options).getRootProjectDir();
            File buildDir = ((ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration)options).getBuildDir();
            parsedArguments.setIncrementalCompilation(Boolean.valueOf(true));
            parsedArguments.setFreeArgs(CollectionsKt.plus((Collection)parsedArguments.getFreeArgs(), (Iterable)javaSources));
            compilationResult = CompilationServiceImplKt.getAsCompilationResult(incrementalCompiler.compile(allSources, (CommonCompilerArguments)parsedArguments, (MessageCollector)loggerAdapter, IcAdaptersKt.getAsChangedFiles(aggregatedIcConfiguration.getSourcesChanges()), rootProjectDir != null && buildDir != null ? new FileLocations(rootProjectDir, buildDir) : null));
        } else if (options == null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable allSources = sources;
            Collection collection2 = parsedArguments.getFreeArgs();
            K2JVMCompilerArguments k2JVMCompilerArguments = parsedArguments;
            boolean $i$f$map = false;
            void classpathChanges = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File rootProjectDir = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAbsolutePath());
            }
            collection = (List)destination$iv$iv;
            k2JVMCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
            compilationResult = CompilationServiceImplKt.getAsCompilationResult(compiler.exec((MessageCollector)loggerAdapter, Services.EMPTY, (CommonCompilerArguments)parsedArguments));
        } else {
            throw new IllegalStateException(("Unexpected incremental compilation configuration: " + options + ". In this version, it must be an instance of ClasspathSnapshotBasedIncrementalJvmCompilationConfiguration for incremental compilation, or null for non-incremental compilation.").toString());
        }
        return compilationResult;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean checkJvmFirRequirements(List<String> arguments) {
        block5: {
            var5_2 = arguments;
            for (T var7_4 : var5_2) {
                it = (String)var7_4;
                $i$a$-find-CompilationServiceImpl$checkJvmFirRequirements$languageVersion$1 = false;
                if (!StringsKt.startsWith$default((String)it, (String)"-language-version", (boolean)false, (int)2, null)) continue;
                v0 = var7_4;
                break block5;
            }
            v0 = null;
        }
        var3_8 = v0;
        if (var3_8 == null) ** GOTO lbl-1000
        it = var3_8;
        $i$a$-let-CompilationServiceImpl$checkJvmFirRequirements$languageVersion$2 = false;
        var4_9 = LanguageVersion.Companion.fromVersionString(StringsKt.substringAfter$default((String)it, (String)"=", null, (int)2, null));
        if (var4_9 != null) {
            v1 = var4_9;
        } else lbl-1000:
        // 2 sources

        {
            v1 = languageVersion = LanguageVersion.LATEST_STABLE;
        }
        if (!(languageVersion.compareTo((Enum)LanguageVersion.KOTLIN_2_0) >= 0)) {
            $i$a$-check-CompilationServiceImpl$checkJvmFirRequirements$1 = false;
            $i$a$-check-CompilationServiceImpl$checkJvmFirRequirements$1 = "FIR incremental compiler runner is only compatible with Kotlin Language Version 2.0";
            throw new IllegalStateException($i$a$-check-CompilationServiceImpl$checkJvmFirRequirements$1.toString());
        }
        if (!arguments.contains("-Xuse-fir-ic")) {
            $i$a$-check-CompilationServiceImpl$checkJvmFirRequirements$2 = false;
            var4_13 = "FIR incremental compiler runner requires '-Xuse-fir-ic' to be present in arguments";
            throw new IllegalStateException(var4_13.toString());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult compileWithinDaemon(ProjectId projectId, KotlinLoggerMessageCollectorAdapter loggerAdapter, CompilerExecutionStrategy.Daemon daemonConfiguration, JvmCompilationConfigurationImpl compilationConfiguration, List<? extends File> sources, List<String> arguments) {
        ExitCode exitCode;
        Object v3;
        int exitCode2;
        block9: {
            AggregatedIcConfiguration<?> aggregatedIcConfiguration;
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DaemonOptions daemonOptions;
            DaemonJVMOptions daemonJVMOptions;
            loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().debug("Compiling using the daemon strategy");
            CompilerId compilerId = CompilerId.Companion.makeCompilerId((Iterable)CompilationServiceImplKt.access$getCurrentClasspath());
            File file = buildIdToSessionFlagFile.computeIfAbsent(projectId, arg_0 -> CompilationServiceImpl.compileWithinDaemon$lambda$1(CompilationServiceImpl::compileWithinDaemon$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"computeIfAbsent(...)");
            File sessionIsAliveFlagFile = file;
            DaemonJVMOptions opts = daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])new String[0], (boolean)true, (boolean)false, (boolean)true);
            boolean bl = false;
            if (!((Collection)daemonConfiguration.getJvmArguments()).isEmpty()) {
                CollectionsKt.addAll((Collection)opts.getJvmParams(), (Iterable)DaemonParamsKt.filterExtractProps((Iterable)daemonConfiguration.getJvmArguments(), (List)opts.getMappers(), (String)"", (RestPropMapper)opts.getRestMapper()));
            }
            DaemonJVMOptions jvmOptions = daemonJVMOptions;
            DaemonOptions $this$compileWithinDaemon_u24lambda_u243 = daemonOptions = new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null);
            boolean bl2 = false;
            if (daemonConfiguration.getShutdownDelay() != null) {
                $this$compileWithinDaemon_u24lambda_u243.setShutdownDelayMilliseconds(daemonConfiguration.getShutdownDelay().toMillis());
            }
            DaemonOptions daemonOptions2 = DaemonParamsKt.configureDaemonOptions((DaemonOptions)daemonOptions);
            File file2 = DaemonAdaptersKt.getClientIsAliveFile();
            CompileServiceSession compileServiceSession = KotlinCompilerRunnerUtils.newDaemonConnection((CompilerId)compilerId, (File)file2, (File)sessionIsAliveFlagFile, (MessageCollector)loggerAdapter, (boolean)true, (DaemonOptions)daemonOptions2, (DaemonJVMOptions)jvmOptions);
            if (compileServiceSession == null) {
                return CompilationServiceImplKt.getAsCompilationResult(ExitCode.INTERNAL_ERROR);
            }
            daemonOptions = compileServiceSession;
            CompileService daemon = daemonOptions.component1();
            int sessionId = daemonOptions.component2();
            CompilationOptions daemonCompileOptions = DaemonAdaptersKt.getAsDaemonCompilationOptions(compilationConfiguration);
            boolean isIncrementalCompilation = daemonCompileOptions instanceof IncrementalCompilationOptions;
            if (isIncrementalCompilation && ((IncrementalCompilationOptions)daemonCompileOptions).getUseJvmFirRunner()) {
                this.checkJvmFirRequirements(arguments);
            }
            Iterable $this$toTypedArray$iv = arguments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$toTypedArray$iv = sources;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            int n = sessionId;
            CompileService compileService = daemon;
            boolean $i$f$map = false;
            thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file3 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getAbsolutePath());
            }
            collection = (List)destination$iv$iv;
            exitCode2 = ((Number)compileService.compile(n, (String[])ArraysKt.plus((Object[])objectArray, (Collection)collection), daemonCompileOptions, (CompilerServicesFacadeBase)new BasicCompilerServicesWithResultsFacadeServer((MessageCollector)loggerAdapter, null, 0, 6, null), (CompilationResults)new DaemonCompilationResults(loggerAdapter.getKotlinLogger$kotlin_build_tools_impl(), (aggregatedIcConfiguration = compilationConfiguration.getAggregatedIcConfiguration$kotlin_build_tools_impl()) != null && (aggregatedIcConfiguration = aggregatedIcConfiguration.getOptions()) != null ? aggregatedIcConfiguration.getRootProjectDir() : null, (BuildMetricsReporter<BuildTimeMetric, BuildPerformanceMetric>)((BuildMetricsReporter)DoNothingBuildMetricsReporter.INSTANCE))).get()).intValue();
            try {
                daemon.releaseCompileSession(sessionId);
            }
            catch (RemoteException e) {
                loggerAdapter.getKotlinLogger$kotlin_build_tools_impl().warn("Unable to release compile session, maybe daemon is already down: " + e);
            }
            Iterable iterable = (Iterable)EntriesMappings.entries$0;
            for (Object t : iterable) {
                ExitCode it = (ExitCode)t;
                boolean bl4 = false;
                if (!(it.getCode() == exitCode2)) continue;
                v3 = t;
                break block9;
            }
            v3 = null;
        }
        if ((exitCode = (ExitCode)v3) == null) {
            exitCode = exitCode2 == 0 ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
        }
        return CompilationServiceImplKt.getAsCompilationResult(exitCode);
    }

    @NotNull
    public String getCompilerVersion() {
        String string = KotlinCompilerVersion.VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VERSION");
        return string;
    }

    private static final File compileWithinDaemon$lambda$0(ProjectId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DaemonAdaptersKt.createSessionIsAliveFlagFile();
    }

    private static final File compileWithinDaemon$lambda$1(Function1 $tmp0, Object p0) {
        return (File)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ExitCode> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ExitCode.values()));
        }
    }
}

