/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.scripting.compiler.plugin.definitions;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.ResultWithDiagnostics;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.ScriptCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.internal.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.definitions.ScriptConfigurationsProvider;
import org.jetbrains.kotlin.buildtools.internal.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.buildtools.internal.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.buildtools.internal.scripting.resolve.RefineCompilationConfigurationKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.resolve.ScriptCompilationConfigurationWrapper;
import org.jetbrains.kotlin.buildtools.internal.scripting.resolve.ScriptReportSink;
import org.jetbrains.kotlin.buildtools.internal.scripting.resolve.VirtualFileScriptSource;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J(\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RF\u0010\b\u001a:\u0012\u0004\u0012\u00020\n\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r0\tj\u001c\u0012\u0004\u0012\u00020\n\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/compiler/plugin/definitions/CliScriptConfigurationsProvider;", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/definitions/ScriptConfigurationsProvider;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "cache", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/ResultWithDiagnostics;", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/resolve/ScriptCompilationConfigurationWrapper;", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/resolve/ScriptCompilationConfigurationResult;", "Lkotlin/collections/HashMap;", "knownVirtualFileSources", "", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/resolve/VirtualFileScriptSource;", "getScriptConfigurationResult", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "providedConfiguration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/ScriptCompilationConfiguration;", "calculateRefinedConfiguration", "kotlin-scripting-compiler"})
public final class CliScriptConfigurationsProvider
extends ScriptConfigurationsProvider {
    @NotNull
    private final ReentrantReadWriteLock cacheLock;
    @NotNull
    private final HashMap<String, ResultWithDiagnostics<ScriptCompilationConfigurationWrapper>> cache;
    @NotNull
    private final Map<String, VirtualFileScriptSource> knownVirtualFileSources;

    public CliScriptConfigurationsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.cacheLock = new ReentrantReadWriteLock();
        this.cache = new HashMap();
        this.knownVirtualFileSources = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> getScriptConfigurationResult(@NotNull KtFile file) {
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            resultWithDiagnostics = this.calculateRefinedConfiguration(file, null);
        }
        finally {
            readLock.unlock();
        }
        return resultWithDiagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> getScriptConfigurationResult(@NotNull KtFile file, @Nullable ScriptCompilationConfiguration providedConfiguration) {
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            resultWithDiagnostics = this.calculateRefinedConfiguration(file, providedConfiguration);
        }
        finally {
            readLock.unlock();
        }
        return resultWithDiagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> calculateRefinedConfiguration(KtFile file, ScriptCompilationConfiguration providedConfiguration) {
        String path = file.getVirtualFilePath();
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> cached = this.cache.get(path);
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics = cached;
        if (resultWithDiagnostics == null) {
            ScriptDefinition scriptDef = DefinitionsKt.findScriptDefinition((PsiFile)file);
            if (scriptDef != null) {
                ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> result = RefineCompilationConfigurationKt.refineScriptCompilationConfiguration(new KtFileScriptSource(file, null, 2, null), scriptDef, this.getProject(), providedConfiguration, this.knownVirtualFileSources);
                ScriptReportSink scriptReportSink = (ScriptReportSink)this.getProject().getService(ScriptReportSink.class);
                if (scriptReportSink != null) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                    scriptReportSink.attachReports(virtualFile, result.getReports());
                }
                ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                for (int i = 0; i < n; ++i) {
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    boolean bl = false;
                    ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics2 = this.cache.put(path, result);
                }
                finally {
                    for (int i = 0; i < n; ++i) {
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
                resultWithDiagnostics = result;
            } else {
                resultWithDiagnostics = null;
            }
        }
        return resultWithDiagnostics;
    }
}

