/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaCodeFragment;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.conflictResolvers.JavaVariableConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.ConflictFilterProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class VariableResolverProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.VARIABLE;
    private boolean myStaticScopeFlag;
    private final PsiClass myAccessClass;
    private PsiElement myCurrentFileContext;

    public VariableResolverProcessor(@NotNull PsiJavaCodeReferenceElement place, @NotNull PsiFile placeFile) {
        if (place == null) {
            VariableResolverProcessor.$$$reportNull$$$0(0);
        }
        if (placeFile == null) {
            VariableResolverProcessor.$$$reportNull$$$0(1);
        }
        super(place.getReferenceName(), ourFilter, new PsiConflictResolver[]{new JavaVariableConflictResolver()}, new SmartList<CandidateInfo>(), place, placeFile);
        PsiClass access = null;
        PsiElement qualifier = place.getQualifier();
        if (qualifier instanceof PsiExpression) {
            JavaResolveResult accessClass = PsiUtil.getAccessObjectClass((PsiExpression)qualifier);
            PsiElement element = accessClass.getElement();
            if (element instanceof PsiTypeParameter) {
                PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(placeFile.getProject());
                PsiClassType type2 = factory2.createType((PsiTypeParameter)element);
                PsiType accessType = accessClass.getSubstitutor().substitute(type2);
                if (accessType instanceof PsiArrayType) {
                    LanguageLevel languageLevel = PsiUtil.getLanguageLevel(placeFile);
                    access = factory2.getArrayClass(languageLevel);
                } else if (accessType instanceof PsiClassType) {
                    access = ((PsiClassType)accessType).resolve();
                }
            } else if (element instanceof PsiClass) {
                access = (PsiClass)element;
            }
        }
        this.myAccessClass = access;
    }

    @Override
    protected boolean stopAtFoundResult(JavaResolveResult cachedResult) {
        if (super.stopAtFoundResult(cachedResult)) {
            PsiElement element;
            JavaCodeFragment.VisibilityChecker visibilityChecker;
            if (this.myPlaceFile instanceof JavaCodeFragment && (visibilityChecker = ((JavaCodeFragment)this.myPlaceFile).getVisibilityChecker()) != null && (element = cachedResult.getElement()) instanceof PsiMember) {
                PsiMember member = (PsiMember)element;
                return JavaResolveUtil.isAccessible(member, member.getContainingClass(), member.getModifierList(), this.myPlace, this.myAccessClass, cachedResult.getCurrentFileResolveScope(), null);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            VariableResolverProcessor.$$$reportNull$$$0(2);
        }
        super.handleEvent(event, associated);
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    @Override
    public void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor2) {
        if (element == null) {
            VariableResolverProcessor.$$$reportNull$$$0(3);
        }
        if (substitutor2 == null) {
            VariableResolverProcessor.$$$reportNull$$$0(4);
        }
        boolean staticProblem = this.myStaticScopeFlag && !((PsiModifierListOwner)element).hasModifierProperty("static") && (element instanceof PsiField || !(element instanceof PsiVariable) || !PsiUtil.isCompileTimeConstant((PsiVariable)element));
        this.add(new CandidateInfo(element, substitutor2, this.myPlace, this.myAccessClass, staticProblem, this.myCurrentFileContext));
    }

    @Override
    public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind) {
        if (kind == null) {
            VariableResolverProcessor.$$$reportNull$$$0(5);
        }
        return kind == ElementClassHint.DeclarationKind.VARIABLE || kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
        if (element == null) {
            VariableResolverProcessor.$$$reportNull$$$0(6);
        }
        if (state2 == null) {
            VariableResolverProcessor.$$$reportNull$$$0(7);
        }
        if (!(element instanceof PsiField) && (this.myName == null || PsiUtil.checkName(element, this.myName, this.myPlace))) {
            super.execute(element, state2);
            return this.myResults.isEmpty();
        }
        return super.execute(element, state2);
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            VariableResolverProcessor.$$$reportNull$$$0(8);
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintKey";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/VariableResolverProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldProcess";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

