/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.diagnostic;

import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.Activity;
import org.jetbrains.kotlin.com.intellij.diagnostic.ParallelActivity;
import org.jetbrains.kotlin.com.intellij.diagnostic.StartUpMeasurer;

public final class ActivityImpl
implements Activity {
    private final String name;
    private String description;
    private final String thread;
    private final long start;
    private long end;
    private final ActivityImpl parent;
    @Nullable
    private final StartUpMeasurer.Level level;
    @Nullable
    private final ParallelActivity parallelActivity;
    @Nullable
    private final String myPluginId;

    @NotNull
    static ActivityImpl createParallelActivity(@NotNull ParallelActivity parallelActivity, @NotNull String name) {
        if (parallelActivity == null) {
            ActivityImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ActivityImpl.$$$reportNull$$$0(1);
        }
        ActivityImpl activityImpl = new ActivityImpl(name, null, System.nanoTime(), null, null, parallelActivity, null);
        if (activityImpl == null) {
            ActivityImpl.$$$reportNull$$$0(2);
        }
        return activityImpl;
    }

    ActivityImpl(@Nullable String name, @Nullable String description2, long start, @Nullable ActivityImpl parent2, @Nullable StartUpMeasurer.Level level, @Nullable ParallelActivity parallelActivity, @Nullable String pluginId) {
        this.name = name;
        this.description = description2 == null || description2.isEmpty() ? null : description2;
        this.start = start;
        this.parent = parent2;
        this.level = level;
        this.parallelActivity = parallelActivity;
        this.myPluginId = pluginId;
        this.thread = Thread.currentThread().getName();
    }

    void setEnd(long end) {
        assert (this.end == 0L);
        this.end = end;
    }

    @Override
    public void end(@Nullable String description2) {
        if (description2 != null) {
            this.description = description2;
        }
        assert (this.end == 0L);
        this.end = System.nanoTime();
        StartUpMeasurer.add(this);
    }

    public String toString() {
        return "ActivityImpl(name=" + this.name + ", start=" + TimeUnit.NANOSECONDS.toMillis(this.start) + ", end=" + TimeUnit.NANOSECONDS.toMillis(this.start) + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parallelActivity";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/diagnostic/ActivityImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/diagnostic/ActivityImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createParallelActivity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThread";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "startChild";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "endAndStart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createParallelActivity";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "endAndStart";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

