/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.AbstractBundle;
import org.jetbrains.kotlin.com.intellij.CommonBundle;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.ide.plugins.OptimizedPluginBean;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginDependency;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.ide.plugins.ProductDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.ComponentConfig;
import org.jetbrains.kotlin.com.intellij.openapi.components.OldComponentConfig;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import org.jetbrains.kotlin.com.intellij.openapi.util.InvalidDataException;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.NullableLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeJdomFactory;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSetInterner;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.messages.ListenerDescriptor;
import org.jetbrains.kotlin.com.intellij.util.xmlb.BeanBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.JDOMXIncluder;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializer;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.JDOMException;
import org.jetbrains.kotlin.org.picocontainer.MutablePicoContainer;

public class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.plugins.PluginDescriptor");
    public static final List<String> SERVICE_QUALIFIED_ELEMENT_NAMES = Arrays.asList("org.jetbrains.kotlin.com.intellij.applicationService", "org.jetbrains.kotlin.com.intellij.projectService", "org.jetbrains.kotlin.com.intellij.moduleService");
    private final File myPath;
    private final boolean myBundled;
    private String myName;
    private PluginId myId;
    private final NullableLazyValue<String> myDescription;
    @Nullable
    private String myProductCode;
    @Nullable
    private Date myReleaseDate;
    private int myReleaseVersion;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myVendorLogoPath;
    private String myCategory;
    private String myUrl;
    private PluginId[] myDependencies;
    private PluginId[] myOptionalDependencies;
    private Map<PluginId, List<String>> myOptionalConfigs;
    private Map<PluginId, List<IdeaPluginDescriptorImpl>> myOptionalDescriptors;
    @Nullable
    private List<Element> myActionElements;
    @Nullable
    private List<ComponentConfig> myAppComponents;
    @Nullable
    private List<ComponentConfig> myProjectComponents;
    @Nullable
    private List<ComponentConfig> myModuleComponents;
    @Nullable
    private MultiMap<String, Element> myExtensions;
    @Nullable
    private List<ServiceDescriptor> myAppServices;
    @Nullable
    private List<ServiceDescriptor> myProjectServices;
    @Nullable
    private List<ServiceDescriptor> myModuleServices;
    @Nullable
    private MultiMap<String, Element> myExtensionsPoints;
    private List<String> myModules;
    private ClassLoader myLoader;
    private String myDescriptionChildText;
    private boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    private boolean myAllowBundledUpdate;
    private boolean myImplementationDetail;
    private String mySinceBuild;
    private String myUntilBuild;
    private boolean myEnabled;
    private List<ListenerDescriptor> myListenerDescriptors;
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    public IdeaPluginDescriptorImpl(@NotNull File pluginPath, boolean bundled) {
        if (pluginPath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(0);
        }
        this.myDescription = NullableLazyValue.createValue(() -> this.computeDescription());
        this.myDependencies = PluginId.EMPTY_ARRAY;
        this.myOptionalDependencies = PluginId.EMPTY_ARRAY;
        this.myEnabled = true;
        this.myPath = pluginPath;
        this.myBundled = bundled;
    }

    @Override
    public File getPath() {
        return this.myPath;
    }

    public void readExternal(@NotNull Element element, @NotNull URL url, @NotNull JDOMXIncluder.PathResolver pathResolver, @Nullable Interner<String> stringInterner) throws InvalidDataException, MalformedURLException {
        Application app;
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(1);
        }
        if (url == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(2);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(3);
        }
        this.readExternal(element, url, (app = ApplicationManager.getApplication()) != null && app.isUnitTestMode(), pathResolver, stringInterner);
    }

    public void loadFromFile(@NotNull File file2, @Nullable SafeJdomFactory factory2, boolean ignoreMissingInclude) throws IOException, JDOMException {
        if (file2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(4);
        }
        this.readExternal(JDOMUtil.load(file2, factory2), file2.toURI().toURL(), ignoreMissingInclude, JDOMXIncluder.DEFAULT_PATH_RESOLVER, factory2 == null ? null : factory2.stringInterner());
    }

    private void readExternal(@NotNull Element element, @NotNull URL url, boolean ignoreMissingInclude, @NotNull JDOMXIncluder.PathResolver pathResolver, @Nullable Interner<String> stringInterner) throws InvalidDataException, MalformedURLException {
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(5);
        }
        if (url == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(6);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(7);
        }
        if (JDOMUtil.isEmpty(element)) {
            return;
        }
        String pluginId = element.getChildTextTrim("id");
        if (pluginId == null) {
            pluginId = element.getChildTextTrim("name");
        }
        if (pluginId == null || !PluginManagerCore.disabledPlugins().contains(pluginId)) {
            JDOMXIncluder.resolveNonXIncludeElement(element, url, ignoreMissingInclude, pathResolver);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Skipping resolving of " + pluginId + " from " + url);
        }
        this.readExternal(element, stringInterner);
    }

    protected void readExternal(@NotNull Element element, @Nullable Interner<String> stringInterner) {
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(8);
        }
        OptimizedPluginBean pluginBean = XmlSerializer.deserialize(element, OptimizedPluginBean.class);
        this.myUrl = pluginBean.url;
        String idString = StringUtil.nullize(pluginBean.id, true);
        String nameString = StringUtil.nullize(pluginBean.name, true);
        this.myId = idString != null ? PluginId.getId(idString) : (nameString != null ? PluginId.getId(nameString) : null);
        this.myName = ObjectUtils.chooseNotNull(nameString, idString);
        ProductDescriptor pd = pluginBean.productDescriptor;
        this.myProductCode = pd != null ? pd.code : null;
        this.myReleaseDate = IdeaPluginDescriptorImpl.parseReleaseDate(pluginBean);
        this.myReleaseVersion = pd != null ? pd.releaseVersion : 0;
        String internalVersionString = pluginBean.formatVersion;
        if (internalVersionString != null) {
            try {
                Integer.parseInt(internalVersionString);
            }
            catch (NumberFormatException e) {
                LOG.error(new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", e, this.myId));
            }
        }
        this.myUseIdeaClassLoader = pluginBean.useIdeaClassLoader;
        this.myAllowBundledUpdate = pluginBean.allowBundledUpdate;
        this.myImplementationDetail = pluginBean.implementationDetail;
        if (pluginBean.ideaVersion != null) {
            this.mySinceBuild = pluginBean.ideaVersion.sinceBuild;
            this.myUntilBuild = IdeaPluginDescriptorImpl.convertExplicitBigNumberInUntilBuildToStar(pluginBean.ideaVersion.untilBuild);
        }
        this.myResourceBundleBaseName = pluginBean.resourceBundle;
        this.myDescriptionChildText = pluginBean.description;
        this.myChangeNotes = pluginBean.changeNotes;
        this.myVersion = pluginBean.pluginVersion;
        if (this.myVersion == null) {
            this.myVersion = PluginManagerCore.getBuildNumber().asStringWithoutProductCode();
        }
        this.myCategory = pluginBean.category;
        if (pluginBean.vendor != null) {
            this.myVendor = pluginBean.vendor.name;
            this.myVendorEmail = pluginBean.vendor.email;
            this.myVendorUrl = pluginBean.vendor.url;
            this.myVendorLogoPath = pluginBean.vendor.logo;
        }
        LinkedHashSet<PluginId> dependentPlugins = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> nonOptionalDependentPlugins = new LinkedHashSet<PluginId>();
        if (pluginBean.dependencies != null) {
            this.myOptionalConfigs = new LinkedHashMap<PluginId, List<String>>();
            for (PluginDependency dependency : pluginBean.dependencies) {
                String text2 = dependency.pluginId;
                if (StringUtil.isEmptyOrSpaces(text2)) continue;
                PluginId id2 = PluginId.getId(text2);
                dependentPlugins.add(id2);
                if (dependency.optional) {
                    if (StringUtil.isEmptyOrSpaces(dependency.configFile)) continue;
                    this.myOptionalConfigs.computeIfAbsent(id2, it -> new SmartList()).add(dependency.configFile);
                    continue;
                }
                nonOptionalDependentPlugins.add(id2);
            }
        }
        this.myDependencies = dependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : dependentPlugins.toArray(PluginId.EMPTY_ARRAY);
        this.myOptionalDependencies = nonOptionalDependentPlugins.size() == dependentPlugins.size() ? PluginId.EMPTY_ARRAY : ContainerUtil.filter(dependentPlugins, id -> !nonOptionalDependentPlugins.contains(id)).toArray(PluginId.EMPTY_ARRAY);
        Ref<BeanBinding> oldComponentConfigBeanBinding = new Ref<BeanBinding>();
        if (stringInterner == null) {
            stringInterner = new HashSetInterner<String>(SERVICE_QUALIFIED_ELEMENT_NAMES);
        }
        MultiMap<String, Element> extensions = this.myExtensions;
        for (Content content : element.getContent()) {
            if (!(content instanceof Element)) continue;
            Element child = (Element)content;
            switch (child.getName()) {
                case "extensions": {
                    String ns = child.getAttributeValue("defaultExtensionNs");
                    for (Element extensionElement : child.getChildren()) {
                        List<ServiceDescriptor> services;
                        String qualifiedExtensionPointName;
                        String os = extensionElement.getAttributeValue("os");
                        if (os != null) {
                            extensionElement.removeAttribute("os");
                            if (!IdeaPluginDescriptorImpl.isComponentSuitableForOs(os)) continue;
                        }
                        if ((qualifiedExtensionPointName = stringInterner.intern(ExtensionsAreaImpl.extractPointName(extensionElement, ns))).equals("org.jetbrains.kotlin.com.intellij.applicationService")) {
                            if (this.myAppServices == null) {
                                this.myAppServices = new ArrayList<ServiceDescriptor>();
                            }
                            services = this.myAppServices;
                        } else if (qualifiedExtensionPointName.equals("org.jetbrains.kotlin.com.intellij.projectService")) {
                            if (this.myProjectServices == null) {
                                this.myProjectServices = new ArrayList<ServiceDescriptor>();
                            }
                            services = this.myProjectServices;
                        } else if (qualifiedExtensionPointName.equals("org.jetbrains.kotlin.com.intellij.moduleService")) {
                            if (this.myModuleServices == null) {
                                this.myModuleServices = new ArrayList<ServiceDescriptor>();
                            }
                            services = this.myModuleServices;
                        } else {
                            if (extensions == null) {
                                this.myExtensions = extensions = MultiMap.createSmart();
                            }
                            extensions.putValue(qualifiedExtensionPointName, extensionElement);
                            continue;
                        }
                        services.add(IdeaPluginDescriptorImpl.readServiceDescriptor(extensionElement));
                    }
                    break;
                }
                case "extensionPoints": {
                    if (this.myExtensionsPoints == null) {
                        this.myExtensionsPoints = MultiMap.createSmart();
                    }
                    for (Element extensionPoint : child.getChildren()) {
                        this.myExtensionsPoints.putValue(StringUtilRt.notNullize(extensionPoint.getAttributeValue("area")), extensionPoint);
                    }
                    break;
                }
                case "actions": {
                    if (this.myActionElements == null) {
                        this.myActionElements = new ArrayList<Element>(child.getChildren());
                        break;
                    }
                    this.myActionElements.addAll(child.getChildren());
                    break;
                }
                case "module": {
                    String moduleName = child.getAttributeValue("value");
                    if (moduleName == null) break;
                    if (this.myModules == null) {
                        this.myModules = new SmartList<String>();
                    }
                    this.myModules.add(moduleName);
                    break;
                }
                case "application-components": {
                    if (this.myAppComponents == null) {
                        this.myAppComponents = new ArrayList<ComponentConfig>();
                    }
                    IdeaPluginDescriptorImpl.readComponents(child, oldComponentConfigBeanBinding, (ArrayList)this.myAppComponents);
                    break;
                }
                case "project-components": {
                    if (this.myProjectComponents == null) {
                        this.myProjectComponents = new ArrayList<ComponentConfig>();
                    }
                    IdeaPluginDescriptorImpl.readComponents(child, oldComponentConfigBeanBinding, (ArrayList)this.myProjectComponents);
                    break;
                }
                case "module-components": {
                    if (this.myModuleComponents == null) {
                        this.myModuleComponents = new ArrayList<ComponentConfig>();
                    }
                    IdeaPluginDescriptorImpl.readComponents(child, oldComponentConfigBeanBinding, (ArrayList)this.myModuleComponents);
                    break;
                }
                case "applicationListeners": {
                    List<ListenerDescriptor> descriptors = this.myListenerDescriptors;
                    if (descriptors == null) {
                        this.myListenerDescriptors = descriptors = new ArrayList<ListenerDescriptor>();
                    }
                    this.readListener(child, descriptors);
                }
            }
            child.getContent().clear();
        }
    }

    private void readListener(@NotNull Element list2, @NotNull List<ListenerDescriptor> descriptors) {
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(9);
        }
        if (descriptors == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(10);
        }
        for (Content content : list2.getContent()) {
            if (!(content instanceof Element)) continue;
            Element child = (Element)content;
            String listenerClassName = child.getAttributeValue("class");
            String topicClassName = child.getAttributeValue("topic");
            if (listenerClassName == null || topicClassName == null) {
                LOG.error("applicationListener descriptor is not correct: " + JDOMUtil.writeElement(child));
                continue;
            }
            String activeInTestMode = child.getAttributeValue("activeInTestMode");
            descriptors.add(new ListenerDescriptor(listenerClassName, topicClassName, activeInTestMode == null || Boolean.parseBoolean(activeInTestMode), this));
        }
    }

    @NotNull
    private static ServiceDescriptor readServiceDescriptor(@NotNull Element element) {
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(11);
        }
        ServiceDescriptor descriptor2 = new ServiceDescriptor();
        descriptor2.serviceInterface = element.getAttributeValue("serviceInterface");
        descriptor2.serviceImplementation = element.getAttributeValue("serviceImplementation");
        descriptor2.testServiceImplementation = element.getAttributeValue("testServiceImplementation");
        descriptor2.configurationSchemaKey = element.getAttributeValue("configurationSchemaKey");
        descriptor2.overrides = Boolean.parseBoolean(element.getAttributeValue("overrides"));
        ServiceDescriptor serviceDescriptor = descriptor2;
        if (serviceDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(12);
        }
        return serviceDescriptor;
    }

    private static void readComponents(@NotNull Element parent2, @NotNull Ref<BeanBinding> oldComponentConfigBean, @NotNull ArrayList<? super ComponentConfig> result2) {
        List<Content> content;
        int contentSize;
        if (parent2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(13);
        }
        if (oldComponentConfigBean == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(15);
        }
        if ((contentSize = (content = parent2.getContent()).size()) == 0) {
            return;
        }
        result2.ensureCapacity(result2.size() + contentSize);
        for (Content child : content) {
            Element componentElement;
            if (!(child instanceof Element) || !(componentElement = (Element)child).getName().equals("component")) continue;
            OldComponentConfig componentConfig = new OldComponentConfig();
            BeanBinding beanBinding = oldComponentConfigBean.get();
            if (beanBinding == null) {
                beanBinding = XmlSerializer.getBeanBinding(componentConfig);
                oldComponentConfigBean.set(beanBinding);
            }
            beanBinding.deserializeInto(componentConfig, componentElement);
            Map options = componentConfig.options;
            if (options != null && !IdeaPluginDescriptorImpl.isComponentSuitableForOs((String)options.get("os"))) continue;
            result2.add(componentConfig);
        }
    }

    @Nullable
    private static Date parseReleaseDate(@NotNull OptimizedPluginBean bean) {
        ProductDescriptor pd;
        String dateStr;
        if (bean == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(16);
        }
        String string2 = dateStr = (pd = bean.productDescriptor) != null ? pd.releaseDate : null;
        if (dateStr != null) {
            try {
                return new SimpleDateFormat("yyyyMMdd", Locale.US).parse(dateStr);
            }
            catch (ParseException e) {
                LOG.info("Error parse release date from plugin descriptor for plugin " + bean.name + " {" + bean.id + "}: " + e.getMessage());
            }
        }
        return null;
    }

    public static String convertExplicitBigNumberInUntilBuildToStar(@Nullable String build2) {
        if (build2 == null) {
            return null;
        }
        Matcher matcher2 = EXPLICIT_BIG_NUMBER_PATTERN.matcher(build2);
        if (matcher2.matches()) {
            return matcher2.group(1) + ".*";
        }
        return build2;
    }

    public void registerExtensionPoints(@NotNull ExtensionsArea area) {
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(17);
        }
        if (this.myExtensionsPoints != null) {
            for (Element element : this.myExtensionsPoints.get(StringUtil.notNullize(area.getAreaClass()))) {
                area.registerExtensionPoint(this, element);
            }
        }
    }

    void registerExtensions(@NotNull ExtensionPointImpl<?>[] extensionPoints, @NotNull MutablePicoContainer picoContainer) {
        if (extensionPoints == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(18);
        }
        if (picoContainer == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(19);
        }
        if (this.myExtensions == null) {
            return;
        }
        for (ExtensionPointImpl<?> extensionPoint : extensionPoints) {
            extensionPoint.createAndRegisterAdapters(this.myExtensions.get(extensionPoint.getName()), this, picoContainer);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public PluginId[] getDependentPluginIds() {
        if (this.myDependencies == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(22);
        }
        return this.myDependencies;
    }

    @Override
    @NotNull
    public PluginId[] getOptionalDependentPluginIds() {
        if (this.myOptionalDependencies == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(23);
        }
        return this.myOptionalDependencies;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public String getCategory() {
        return this.myCategory;
    }

    @NotNull
    public List<File> getClassPath() {
        if (this.myPath.isDirectory()) {
            File[] files2;
            ArrayList<File> result2 = new ArrayList<File>();
            File classesDir = new File(this.myPath, "classes");
            if (classesDir.exists()) {
                result2.add(classesDir);
            }
            if ((files2 = new File(this.myPath, "lib").listFiles()) != null && files2.length > 0) {
                for (File f : files2) {
                    if (f.isFile()) {
                        String name = f.getName();
                        if (!StringUtil.endsWithIgnoreCase(name, ".jar") && !StringUtil.endsWithIgnoreCase(name, ".zip")) continue;
                        result2.add(f);
                        continue;
                    }
                    result2.add(f);
                }
            }
            ArrayList<File> arrayList = result2;
            if (arrayList == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(24);
            }
            return arrayList;
        }
        List<File> list2 = Collections.singletonList(this.myPath);
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(25);
        }
        return list2;
    }

    public void setLoader(ClassLoader loader) {
        this.myLoader = loader;
    }

    @Override
    public PluginId getPluginId() {
        return this.myId;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    @Override
    public boolean getUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    void setUseCoreClassLoader(boolean useCoreClassLoader) {
        this.myUseCoreClassLoader = useCoreClassLoader;
    }

    private String computeDescription() {
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = AbstractBundle.getResourceBundle(this.myResourceBundleBaseName, this.getPluginClassLoader());
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        if (bundle == null) {
            return this.myDescriptionChildText;
        }
        return CommonBundle.messageOrDefault(bundle, "plugin." + this.myId + ".description", StringUtil.notNullize(this.myDescriptionChildText), new Object[0]);
    }

    void insertDependency(@NotNull IdeaPluginDescriptor d) {
        if (d == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(33);
        }
        PluginId[] deps = new PluginId[this.getDependentPluginIds().length + 1];
        deps[0] = d.getPluginId();
        System.arraycopy(this.myDependencies, 0, deps, 1, deps.length - 1);
        this.myDependencies = deps;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled2) {
        this.myEnabled = enabled2;
    }

    @Override
    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    @Override
    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    Map<PluginId, List<String>> getOptionalConfigs() {
        return this.myOptionalConfigs;
    }

    @Nullable
    Map<PluginId, List<IdeaPluginDescriptorImpl>> getOptionalDescriptors() {
        return this.myOptionalDescriptors;
    }

    void setOptionalDescriptors(@Nullable Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalDescriptors) {
        this.myOptionalDescriptors = optionalDescriptors;
    }

    void mergeOptionalConfig(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(34);
        }
        if (this.myExtensions == null) {
            this.myExtensions = descriptor2.myExtensions;
        } else if (descriptor2.myExtensions != null) {
            this.myExtensions.putAllValues(descriptor2.myExtensions);
        }
        if (this.myExtensionsPoints == null) {
            this.myExtensionsPoints = descriptor2.myExtensionsPoints;
        } else if (descriptor2.myExtensionsPoints != null) {
            this.myExtensionsPoints.putAllValues(descriptor2.myExtensionsPoints);
        }
        if (this.myActionElements == null) {
            this.myActionElements = descriptor2.myActionElements;
        } else if (descriptor2.myActionElements != null) {
            this.myActionElements.addAll(descriptor2.myActionElements);
        }
        this.myAppComponents = IdeaPluginDescriptorImpl.concatOrNull(this.myAppComponents, descriptor2.myAppComponents);
        this.myProjectComponents = IdeaPluginDescriptorImpl.concatOrNull(this.myProjectComponents, descriptor2.myProjectComponents);
        this.myModuleComponents = IdeaPluginDescriptorImpl.concatOrNull(this.myModuleComponents, descriptor2.myModuleComponents);
        this.myAppServices = IdeaPluginDescriptorImpl.concatOrNull(this.myAppServices, descriptor2.myAppServices);
        this.myProjectServices = IdeaPluginDescriptorImpl.concatOrNull(this.myProjectServices, descriptor2.myProjectServices);
        this.myModuleServices = IdeaPluginDescriptorImpl.concatOrNull(this.myModuleServices, descriptor2.myModuleServices);
        this.myListenerDescriptors = IdeaPluginDescriptorImpl.concatOrNull(this.myListenerDescriptors, descriptor2.myListenerDescriptors);
    }

    @Nullable
    private static <T> List<T> concatOrNull(@Nullable List<T> l1, @Nullable List<T> l2) {
        if (l1 == null) {
            return l2;
        }
        if (l2 == null) {
            return l1;
        }
        return ContainerUtil.concat(l1, l2);
    }

    @Override
    public boolean isBundled() {
        return this.myBundled;
    }

    @Override
    public boolean isImplementationDetail() {
        return this.myImplementationDetail;
    }

    @NotNull
    public List<String> getModules() {
        List<String> list2 = ContainerUtil.notNullize(this.myModules);
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(35);
        }
        return list2;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof IdeaPluginDescriptorImpl && this.myId == ((IdeaPluginDescriptorImpl)o).myId;
    }

    public int hashCode() {
        return Objects.hashCode(this.myId);
    }

    public String toString() {
        return "PluginDescriptor(name=" + this.myName + ", classpath=" + this.myPath + ")";
    }

    private static boolean isComponentSuitableForOs(@Nullable String os) {
        if (StringUtil.isEmpty(os)) {
            return true;
        }
        if (os.equals(Extensions.OS.mac.name())) {
            return SystemInfo.isMac;
        }
        if (os.equals(Extensions.OS.linux.name())) {
            return SystemInfo.isLinux;
        }
        if (os.equals(Extensions.OS.windows.name())) {
            return SystemInfo.isWindows;
        }
        if (os.equals(Extensions.OS.unix.name())) {
            return SystemInfo.isUnix;
        }
        if (os.equals(Extensions.OS.freebsd.name())) {
            return SystemInfo.isFreeBSD;
        }
        throw new IllegalArgumentException("Unknown OS '" + os + "'");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginPath";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldComponentConfigBean";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoints";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picoContainer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readServiceDescriptor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentPluginIds";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalDependentPluginIds";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppComponents";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectComponents";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleComponents";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppServices";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getListeners";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectServices";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleServices";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readServiceDescriptor";
                break;
            }
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readComponents";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseReleaseDate";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "insertDependency";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfig";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

