/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.util.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conditions {
    public static final Condition<Object> TRUE = Condition.TRUE;
    public static final Condition<Object> FALSE = Condition.FALSE;

    @NotNull
    public static <T> Condition<T> alwaysTrue() {
        Condition<Object> condition = TRUE;
        if (condition == null) {
            Conditions.$$$reportNull$$$0(0);
        }
        return condition;
    }

    @NotNull
    public static <T> Condition<T> alwaysFalse() {
        Condition<Object> condition = FALSE;
        if (condition == null) {
            Conditions.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @NotNull
    public static <T> Condition<T> notNull() {
        Condition<Object> condition = Condition.NOT_NULL;
        if (condition == null) {
            Conditions.$$$reportNull$$$0(2);
        }
        return condition;
    }

    @NotNull
    public static <T> Condition<T> instanceOf(final @NotNull Class<?> clazz) {
        if (clazz == null) {
            Conditions.$$$reportNull$$$0(4);
        }
        Condition condition = new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        };
        if (condition == null) {
            Conditions.$$$reportNull$$$0(5);
        }
        return condition;
    }

    @NotNull
    public static <T> Condition<T> not(@NotNull Condition<? super T> c) {
        if (c == null) {
            Conditions.$$$reportNull$$$0(19);
        }
        if (c == TRUE) {
            Condition<T> condition = Conditions.alwaysFalse();
            if (condition == null) {
                Conditions.$$$reportNull$$$0(20);
            }
            return condition;
        }
        if (c == FALSE) {
            Condition<T> condition = Conditions.alwaysTrue();
            if (condition == null) {
                Conditions.$$$reportNull$$$0(21);
            }
            return condition;
        }
        if (c instanceof Not) {
            Condition condition = ((Not)c).c;
            if (condition == null) {
                Conditions.$$$reportNull$$$0(22);
            }
            return condition;
        }
        Not<? super T> not = new Not<T>(c);
        if (not == null) {
            Conditions.$$$reportNull$$$0(23);
        }
        return not;
    }

    @NotNull
    public static <T> Condition<T> and(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
        if (c1 == null) {
            Conditions.$$$reportNull$$$0(24);
        }
        if (c2 == null) {
            Conditions.$$$reportNull$$$0(25);
        }
        Condition<? super T> condition = Conditions.and2(c1, c2);
        if (condition == null) {
            Conditions.$$$reportNull$$$0(26);
        }
        return condition;
    }

    @NotNull
    public static <T> Condition<T> and2(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
        if (c1 == null) {
            Conditions.$$$reportNull$$$0(27);
        }
        if (c2 == null) {
            Conditions.$$$reportNull$$$0(28);
        }
        if (c1 == TRUE || c2 == FALSE) {
            Condition<? super T> condition = c2;
            if (condition == null) {
                Conditions.$$$reportNull$$$0(29);
            }
            return condition;
        }
        if (c2 == TRUE || c1 == FALSE) {
            Condition<? super T> condition = c1;
            if (condition == null) {
                Conditions.$$$reportNull$$$0(30);
            }
            return condition;
        }
        And<? super T> and = new And<T>(c1, c2);
        if (and == null) {
            Conditions.$$$reportNull$$$0(31);
        }
        return and;
    }

    @NotNull
    public static <A, B> Condition<A> compose(final @NotNull Function<? super A, B> fun, final @NotNull Condition<? super B> condition) {
        if (fun == null) {
            Conditions.$$$reportNull$$$0(40);
        }
        if (condition == null) {
            Conditions.$$$reportNull$$$0(41);
        }
        Condition condition2 = new Condition<A>(){

            @Override
            public boolean value(A o) {
                return condition.value(fun.fun(o));
            }
        };
        if (condition2 == null) {
            Conditions.$$$reportNull$$$0(42);
        }
        return condition2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/Conditions";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 19: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 24: 
            case 27: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 25: 
            case 28: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysTrue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysFalse";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "constant";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/Conditions";
                break;
            }
            case 5: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "instanceOf";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "notInstanceOf";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "assignableTo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "is";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "equalTo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "notEqualTo";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "oneOf";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "not";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "and2";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "or2";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "compose";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "cached";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notInstanceOf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assignableTo";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "oneOf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "not";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "and2";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "or2";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "compose";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "cached";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class And<T>
    implements Condition<T> {
        final Condition<? super T> c1;
        final Condition<? super T> c2;

        And(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
            if (c1 == null) {
                And.$$$reportNull$$$0(0);
            }
            if (c2 == null) {
                And.$$$reportNull$$$0(1);
            }
            this.c1 = c1;
            this.c2 = c2;
        }

        @Override
        public boolean value(T object) {
            return this.c1.value(object) && this.c2.value(object);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c2";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/Conditions$And";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Not<T>
    implements Condition<T> {
        final Condition<? super T> c;

        Not(@NotNull Condition<? super T> c) {
            if (c == null) {
                Not.$$$reportNull$$$0(0);
            }
            this.c = c;
        }

        @Override
        public boolean value(T value2) {
            return !this.c.value(value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/com/intellij/openapi/util/Conditions$Not", "<init>"));
        }
    }
}

