/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;

public interface PsiFile
extends PsiFileSystemItem {
    public static final PsiFile[] EMPTY_ARRAY = new PsiFile[0];

    @Override
    public VirtualFile getVirtualFile();

    public PsiDirectory getContainingDirectory();

    @Override
    public PsiDirectory getParent();

    public long getModificationStamp();

    @NotNull
    public PsiFile getOriginalFile();

    @NotNull
    public FileType getFileType();

    @Deprecated
    @NotNull
    public PsiFile[] getPsiRoots();

    @NotNull
    public FileViewProvider getViewProvider();

    @Override
    public FileASTNode getNode();

    public void subtreeChanged();

    default public void clearCaches() {
    }

    @Nullable
    default public IFileElementType getFileElementType() {
        return ObjectUtils.tryCast(PsiUtilCore.getElementType(this.getNode()), IFileElementType.class);
    }
}

