/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;

public class URLUtil {
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset(?:=|:)[^,;]+)?(;base64)?,(.+)");
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern URL_WITH_PARENS_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;()]*[-A-Za-z0-9+$&@#/%=~_|()]");
    public static final Pattern FILE_URL_PATTERN = Pattern.compile("\\b(file:///)[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");

    private URLUtil() {
    }

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        String protocol;
        if (url == null) {
            URLUtil.$$$reportNull$$$0(1);
        }
        InputStream inputStream = (protocol = url.getProtocol()).equals("jar") ? URLUtil.openJarStream(url) : url.openStream();
        if (inputStream == null) {
            URLUtil.$$$reportNull$$$0(2);
        }
        return inputStream;
    }

    @NotNull
    public static InputStream openResourceStream(@NotNull URL url) throws IOException {
        InputStream inputStream;
        if (url == null) {
            URLUtil.$$$reportNull$$$0(3);
        }
        try {
            inputStream = URLUtil.openStream(url);
        }
        catch (FileNotFoundException ex) {
            InputStream resourceStream;
            int pos;
            String protocol = url.getProtocol();
            String file2 = null;
            if (protocol.equals("file")) {
                file2 = url.getFile();
            } else if (protocol.equals("jar") && (pos = url.getFile().indexOf("!")) >= 0) {
                file2 = url.getFile().substring(pos + 1);
            }
            if (file2 != null && file2.startsWith("/") && (resourceStream = URLUtil.class.getResourceAsStream(file2)) != null) {
                InputStream inputStream2 = resourceStream;
                if (inputStream2 == null) {
                    URLUtil.$$$reportNull$$$0(5);
                }
                return inputStream2;
            }
            throw ex;
        }
        if (inputStream == null) {
            URLUtil.$$$reportNull$$$0(4);
        }
        return inputStream;
    }

    @NotNull
    private static InputStream openJarStream(@NotNull URL url) throws IOException {
        Pair<String, String> paths;
        if (url == null) {
            URLUtil.$$$reportNull$$$0(6);
        }
        if ((paths = URLUtil.splitJarUrl(url.getFile())) == null) {
            throw new MalformedURLException(url.getFile());
        }
        final ZipFile zipFile2 = new ZipFile((String)paths.first);
        ZipEntry zipEntry = zipFile2.getEntry((String)paths.second);
        if (zipEntry == null) {
            zipFile2.close();
            throw new FileNotFoundException("Entry " + (String)paths.second + " not found in " + (String)paths.first);
        }
        FilterInputStream filterInputStream = new FilterInputStream(zipFile2.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile2.close();
            }
        };
        if (filterInputStream == null) {
            URLUtil.$$$reportNull$$$0(7);
        }
        return filterInputStream;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static ThreeState resourceExists(@NotNull URL url) {
        block26: {
            ThreeState threeState;
            Throwable throwable;
            ZipFile file2;
            block24: {
                block25: {
                    if (url == null) {
                        URLUtil.$$$reportNull$$$0(8);
                    }
                    if (url.getProtocol().equals("file")) {
                        ThreeState threeState2 = ThreeState.fromBoolean(URLUtil.urlToFile(url).exists());
                        if (threeState2 == null) {
                            URLUtil.$$$reportNull$$$0(9);
                        }
                        return threeState2;
                    }
                    if (!url.getProtocol().equals("jar")) break block26;
                    Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
                    if (paths == null) {
                        ThreeState threeState3 = ThreeState.NO;
                        if (threeState3 == null) {
                            URLUtil.$$$reportNull$$$0(10);
                        }
                        return threeState3;
                    }
                    if (!new File((String)paths.first).isFile()) {
                        ThreeState threeState4 = ThreeState.NO;
                        if (threeState4 == null) {
                            URLUtil.$$$reportNull$$$0(11);
                        }
                        return threeState4;
                    }
                    file2 = new ZipFile((String)paths.first);
                    throwable = null;
                    threeState = ThreeState.fromBoolean(file2.getEntry((String)paths.second) != null);
                    if (file2 == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        file2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                file2.close();
            }
            ThreeState threeState5 = threeState;
            if (threeState5 == null) {
                URLUtil.$$$reportNull$$$0(12);
            }
            return threeState5;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (file2 != null) {
                                if (throwable != null) {
                                    try {
                                        file2.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    file2.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        ThreeState threeState6 = ThreeState.NO;
                        if (threeState6 == null) {
                            URLUtil.$$$reportNull$$$0(13);
                        }
                        return threeState6;
                    }
                }
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            URLUtil.$$$reportNull$$$0(14);
        }
        return threeState;
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(@NotNull String url) {
        String jarPath;
        String resourcePath;
        block7: {
            int pivot;
            if (url == null) {
                URLUtil.$$$reportNull$$$0(15);
            }
            if ((pivot = url.indexOf("!/")) < 0) {
                return null;
            }
            resourcePath = url.substring(pivot + 2);
            jarPath = url.substring(0, pivot);
            if (StringUtil.startsWithConcatenation(jarPath, "jar", ":")) {
                jarPath = jarPath.substring("jar".length() + 1);
            }
            if (jarPath.startsWith("file")) {
                try {
                    jarPath = URLUtil.urlToFile(new URL(jarPath)).getPath().replace('\\', '/');
                }
                catch (Exception e) {
                    jarPath = jarPath.substring("file".length());
                    if (jarPath.startsWith("://")) {
                        jarPath = jarPath.substring("://".length());
                    }
                    if (!StringUtil.startsWithChar(jarPath, ':')) break block7;
                    jarPath = jarPath.substring(1);
                }
            }
        }
        return Pair.create(jarPath, resourcePath);
    }

    @NotNull
    public static File urlToFile(@NotNull URL url) {
        File file2;
        block3: {
            if (url == null) {
                URLUtil.$$$reportNull$$$0(16);
            }
            try {
                file2 = new File(url.toURI().getSchemeSpecificPart());
                if (file2 != null) break block3;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + url.toString() + "'", e);
            }
            URLUtil.$$$reportNull$$$0(17);
        }
        return file2;
    }

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        if (s == null) {
            URLUtil.$$$reportNull$$$0(18);
        }
        String string2 = URLUtil.unescapePercentSequences(s, 0, s.length()).toString();
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(19);
        }
        return string2;
    }

    @NotNull
    public static CharSequence unescapePercentSequences(@NotNull CharSequence s, int from, int end) {
        int i;
        if (s == null) {
            URLUtil.$$$reportNull$$$0(20);
        }
        if ((i = StringUtil.indexOf(s, '%', from, end)) == -1) {
            CharSequence charSequence = s.subSequence(from, end);
            if (charSequence == null) {
                URLUtil.$$$reportNull$$$0(21);
            }
            return charSequence;
        }
        StringBuilder decoded = new StringBuilder();
        decoded.append(s, from, i);
        TIntArrayList bytes = null;
        while (i < end) {
            char c = s.charAt(i);
            if (c == '%') {
                if (bytes == null) {
                    bytes = new TIntArrayList();
                } else {
                    bytes.clear();
                }
                while (i + 2 < end && s.charAt(i) == '%') {
                    int d1 = URLUtil.decode(s.charAt(i + 1));
                    int d2 = URLUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = (byte)bytes.getQuick(j);
                    }
                    decoded.append(new String(bytesArray, StandardCharsets.UTF_8));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        StringBuilder stringBuilder = decoded;
        if (stringBuilder == null) {
            URLUtil.$$$reportNull$$$0(22);
        }
        return stringBuilder;
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    @NotNull
    public static URL getJarEntryURL(@NotNull File file2, @NotNull String pathInJar) throws MalformedURLException {
        if (file2 == null) {
            URLUtil.$$$reportNull$$$0(31);
        }
        if (pathInJar == null) {
            URLUtil.$$$reportNull$$$0(32);
        }
        String fileURL = StringUtil.replace(file2.toURI().toASCIIString(), "!", "%21");
        URL uRL = new URL("jar:" + fileURL + "!/" + StringUtil.trimLeading(pathInJar, '/'));
        if (uRL == null) {
            URLUtil.$$$reportNull$$$0(33);
        }
        return uRL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 36: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 15: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/URLUtil";
                break;
            }
            case 18: 
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataUrl";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshUrl";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/URLUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "openStream";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "openResourceStream";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "openJarStream";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resourceExists";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToFile";
                break;
            }
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePercentSequences";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHostFromSshUrl";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarEntryURL";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeURIComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canContainUrl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openStream";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 36: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openResourceStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openJarStream";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resourceExists";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "urlToFile";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unescapePercentSequences";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDataUri";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBytesFromDataUri";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseHostFromSshUrl";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getJarEntryURL";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "encodeURIComponent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findUrl";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 27: 
            case 28: 
            case 30: 
            case 33: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

